(* :Title: ComparisonPages.m *)

(* :Author:
  Andrew Hunt, andy@wolfram.com
*)

(* :Mathematica Version: 6 *)
(* :Package Version: $Revision: 1.8 $ $Date: 2016/05/31 19:35:59 $ *)                  
(* :Copyright: (c) 2006, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: General transform for Mathematica Marketing Pages *)


XMLTransform[{

(* Transform Notebook *)
_Notebook :>  Block[{title, pageTitle="xxx", nbExpr, expr, introHolder, restNBExpr, exampleholder, sidebarCells, buildNumber},

  nbExpr = SelectLiteral@SelectSelf[];
  title = GetParameter["titleName"];

  (* determine build number *)
  buildNumber = StringCases[GetAbsoluteFileName[], RegularExpression["\\d\\d\\d\\d\\d\\d"]];

  (* grab cells for sidebar *)
  sidebarCells = Cases[nbExpr, Cell[CellGroupData[{Cell[c_, "ComparisonSubpageSection", o___], r___}, g_]], Infinity];
(*  sidebarCells = Cases[sidebarCells, Cell[CellGroupData[{Cell[_, "ComparisonContentsSection", ___], ___}, _]], Infinity];*)
  sidebarCells = DeleteCases[sidebarCells, Cell[_, "Input", ___], Infinity];
  (* delete cells from notebook *)
  expr = First@DeleteCases[nbExpr, Cell[CellGroupData[{Cell[_, "ComparisonSubpageSection", ___], ___}, _]], Infinity];

  (* create a .html-head file if there's a filename *)
  If[GetFileNameBase[] =!= "",
    Export[ 
      StringJoin[GetFileNameBase[], ".html-head"],
      XML`RawXML[ StringJoin[ExportString[#, "XML"] & /@ 
        Flatten[{
          XMLElement["title", {}, {title }],
          If[Length@GetParameter["keywords"] > 0, 
            XMLElement["meta", {
            "name"->"keywords", 
            "content"->StringList[GetParameter["keywords"]] }, {}], {}]
        }]]], 
      "XML"];
  ];
  
  DIV[{
    DIV[{"class"->"ComparisonSidebar"}, {" "}(*Flatten@{ Recurse @ sidebarCells, Br[], Img[{"src"->"/common/images2003/spacer.gif", "height"->"1", "width"->"1", "border"->"0"}] }*)],
    DIV[{"class"->"ComparisonContainer"}, Flatten@{
      (*DIV[{"class"->"toptext"},{ XML`RawXML@"How <i>Mathematica</i> Compares" }],*)
      Recurse @ expr,
      Br[],
      Br[],
      DIV[{"class"->"footer"}, {
        A[{"href"->"mailto:suggestions@wolfram.com?Subject=comparison%20suggestion"}, {"Any questions about topics on this page? Click here to get an individual response."}]
      }]
      }]
  }]
],


(************************

Define cell transforms 

************************)
{Cell, "History"|"Synonyms"|"SynonymsSection"} :> Unevaluated@Sequence[],


(* General styles *)
{Cell, "ComparisonTitle"} :> 
Block[{ dir},
  pageTitle = Recurse[];
  dir = DocumentationBuild`Utils`MakeCamelCaseString @ pageTitle;
  Sequence@@{
    H1[{"id"->"title", "name"->"title"}, { pageTitle }],
    DIV[{"class"->"ComparisonTitle"}, {Img[{"src"->"../images/headers/" <> dir <> "/header.gif"}] }],
    DIV[{"class"->"redlinelayer"}, { DIV[{"class"->"redline"}, { Img[{ "src"->"/common/images/spacer.gif", "width"->"1", "height"->"1"}] }] }]
}],

{Cell, "ComparisonListing"} :> 
Module[{ c = SelectLiteral@SelectSelf[]},
  c = First@c;
  DIV[{"class"->"ComparisonListing"}, Flatten@{ Recurse @ c }]
],
  
{Cell, "ComparisonContentsSection"} :> Sequence[],

{Cell, "ComparisonAbstract"} :> 
  DIV[{"class"->"abstract"}, { Recurse[] }],

{CellGroupData, "ComparisonSeeAlsoSection" | "ComparisonRelatedLinksSection" | "ComparisonFeaturesSection" | "ComparisonTidbitsSection" | "ComparisonInteroperabilitySection" | "ComparisonAdvantagesSection"} :> 
Module[{heading, group},
heading = Recurse[First@First@SelectSelf[] ];
  group = Recurse[Rest@First@SelectSelf[] ];
  
  Sequence[{
    heading,
    UL[{"class"->"ComparisonBulletList"}, { group }]
  }]
],

{Cell, "ComparisonSeeAlsoSection" | "ComparisonRelatedLinksSection" | "ComparisonFeaturesSection" | "ComparisonTidbitsSection" | "ComparisonInteroperabilitySection" | "ComparisonAdvantagesSection"} :> 
  DIV[{"class"->"ComparisonHeader"}, { Recurse[] }],

{Cell, "ComparisonSeeAlso" | "ComparisonRelatedLinks" | "ComparisonFeatures" | "ComparisonTidbits" | "ComparisonInteroperability" | "ComparisonAdvantages"} :> 
Module[{u, cell, res},
  res = Recurse[];
  cell = SelectLiteral@SelectSelf[];
  u = Cases[cell, ButtonBox[">>" | "\[RightGuillemet]", ___, 
                    Rule[ButtonData, d_String | {URL[d_String, ___], ___}], ___] :> d, Infinity];
  XMLElement["li", {}, {
    If[Length@u > 0, 
      A[{"href"->First@u, "class"->"bulletTextLink", "target"->"_top"}, { res }],
      res
    ]
  }] 
],

{CellGroupData, "ComparisonInternalInformationSection"} :>
Block[{contents, compPage},
  contents = Rest@First@SelectChildren[];
  compPage = GetFileNameBase[] <> ".html-compinfo";
  Export[ compPage, 
  (* create *)
"<html><head>
<link 
<title>" <> title <> "</title>
</head>
<body style='margin: 0px;'>
<div style='background-color:#000000'><img src='/images/wrilogoComp.gif' alt='' width='151' height='31' border='0'></div>
<div style='background-color:#E38D12'><img src='/images/confidential.gif' alt='' width='203' height='17' border='0'></div>
<div style='margin:15px;margin-top:25px'>
" <>
ExportString[ H3[{"style"->"margin-bottom:5px; font-family:Verdana;"}, { pageTitle }], "XML"] <> "
" <>
ExportString[ DIV[{"style"->"font-size:10px; font-family:Verdana;"}, { Recurse@contents }] , "XML"] <>
"<br><br><br>
<span style='font-size:8px; font-family:Verdana;'>This information is accurate to the best of our knowledge. Please report any mistakes to
<a
href='mailto:t-competition@wolfram.com'>t-competition@wolfram.com</a>.</span>
</p>
</div>
</body></html>", 
  "TEXT"
]; 
],

{Cell, "ComparisonInternalInformationSection"} :> Sequence[],

{Cell, "ComparisonInternalInformation"} :>
  P[{ Recurse[] }],

{Cell, "Output"} :> 
Module[{cell, thumb, popupContent, popup, count, src, w, h, srcThumb, wThumb, hThumb, w2, h2, hOffsetThumbmag, wOffsetMainImage},
  cell = SelectLiteral[SelectSelf[]];
  count = IncrementCounter["Image"];
 
  popupContent = Recurse@group;

  (* Information for popup windows *)
  {src, w, h} = {"URL"/.#,"Width"/.#,"Height"/.#}& [ 
    BoxToImage[
      ToFileName[{"HTMLImages", GetFileNameBase[]},
        count <> ".gif"],
        cell,
        Inline -> True
    ]];
  w2=ToExpression[w]+45; h2=ToExpression[h]+40;

  {srcThumb, wThumb, hThumb} = {"URL"/.#,"Width"/.#,"Height"/.#}& [ 
    BoxToImage[
      ToFileName[{"HTMLImages", GetFileNameBase[]}, 
        "thumb_" <> count <> ".gif"],
        cell, 
        Inline -> True,
        ImageSize -> {150, Automatic}
      ]];

  {wThumb, hThumb} = Import[ToFileName[{"HTMLImages", GetFileNameBase[]}, "thumb_" <> count <> ".gif"], "ImageSize"];
  hOffsetThumbmag = hThumb - 2;
  wOffsetMainImage = wThumb - ToExpression@w - 30;

  DIV[ {"class"->"thumbholder"}, {
    Span[{"name" -> "parent_Detail", "id" -> "parent_Detail"}, {
       DIV[{"class" -> "DetailLayerBox", "style"->"left:"<>ToString@wOffsetMainImage,
           "name" -> "Layer_"<>count, "id" -> "Layer_"<>count,
           "onmouseover" -> "javascript:showDetail('Layer_"<>count<>"')",
           "onmouseout" -> "javascript:hideDetail('Layer_"<>count<>"')"}, {
         DIV[{"class" -> "DetailLayerContent"}, {
           popupContent (*Img[{"src"->src, "width"->ToString@w, "height"->ToString@h}] *)
         }]
         }]
      }],
      A[{"onmouseover" -> "javascript:showDetail('Layer_"<>count<>"');return(true);",
         "onmouseout" -> "javascript:hideDetail('Layer_"<>count<>"');return(true);",
         "id" -> "head_"<>count,
         "href"->"#"}, {
            DIV[{"class" -> "thumb"}, Flatten[{
              Img[{"src"->srcThumb, "width"->ToString@wThumb, "height"->ToString@hThumb}],
    DIV[{"class"->"thumbmag", "style"->"left:146; top:"<>ToString@hOffsetThumbmag }, {
      Img[{"src"->"/common/images2003/spacer.gif", "height"->"1", "width"->"1", "border"->"0"}]
      }]     
        }]]
        }]
   }]
],

(****

Default

*****)


{Cell, "Graphics" | "Picture"} :> 
  transmogrifyImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
    "G_" <> IncrementCounter["Images"] <> ".gif"],
     Inline -> True, CropImage -> False],


{BoxData}:> Recurse[]

(*{CellGroupData, All} :> Recurse[], *)
(*
{TextData, All} :> Recurse[],

{Cell, All} :>
If[GetStyle[]===None, 
  DIV[{}, {Recurse[]} ], 
  DIV[{"class" -> GetStyle[]}, {Recurse[]} ]
]
*)

}, 

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},
DefaultParameters -> { "newline2br" -> False, "newline2div" -> False}

]
