(* :Title: CapabilitiesPages.m *)

(* :Author:
  Andrew Hunt, andy@wolfram.com
*)

(* :Mathematica Version: 6 *)
(* :Package Version: $Revision: 1.4 $ $Date: 2016/05/31 19:35:59 $ *)                  
(* :Copyright: (c) 2006, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: General transform for Mathematica Capabilities Pages *)


XMLTransform[{

(* Transform Notebook *)
_Notebook :>  Block[{sectionName, title, nbExpr, restNBExpr, exampleholder, mainFileNameBase, iNumber, mainFileNameNumber, filename, buildNumber},

  sectionName = "XXX";

  nbExpr = SelectLiteral@SelectSelf[];
  exampleholder = 0;
  title = GetParameter["titleName"];
  mainFileNameBase = GetFileNameBase[];
  mainFileNameNumber = 0;
  filename = StringReplace[DirectoryName@GetParameter["filename"], {DirectoryName@DirectoryName@GetParameter["filename"]->"", "/" | "\\" -> ""}];
  iNumber = 0;

  (* determine build number *)
  buildNumber = StringCases[GetAbsoluteFileName[], RegularExpression["\\d\\d\\d\\d\\d\\d"]];
  buildNumber = If[Length@buildNumber > 0, First@buildNumber, "Indeterminable"];

  (* create a .html-head file if there's a filename *)
  If[mainFileNameBase =!= "",
    Export[ 
      StringJoin[mainFileNameBase, ".html-head"],
      XML`RawXML[ StringJoin[ExportString[#, "XML"] & /@ 
        Flatten[{
          XMLElement["title", {}, {title }],
          If[Length@GetParameter["keywords"] > 0, 
            XMLElement["meta", {
            "name"->"keywords", 
            "content"->StringList[GetParameter["keywords"]] }, {}], {}],
          If[Length@GetParameter["synonyms"] > 0, 
            XMLElement["meta", {
            "name"->"synonyms", 
            "content"->StringList[GetParameter["synonyms"]] }, {}], {}]
        }]]], 
      "XML"];
  ];  

  (* return page *)
  DIV[{"class"->"capabilitywrapper"}, {
    Recurse[],
    Br[],
    Br[],
    Br[],
    "\[NonBreakingSpace]"
  }]

],


(************************

Define cell transforms 

************************)

(* General styles *)

{Cell, "CapabilitiesTitle"} :> 
  H1[{"class"->"title"}, {Recurse[]}],

{Cell, "CapabilitiesText"} :>
  DIV[{"class" -> "text"}, {Recurse[]} ],

{Cell, "CapabilitiesSlideshowSection"} :>
  DIV[{"class" -> "slideshowHolder"}, {Recurse[]} ],

{Cell, "CapabilitiesFeaturesSection"} :>
  H2[{"class" -> "featuresHolder"}, {Recurse[]} ],
  


{CellGroupData, "CapabilitiesRelatedLinksSection"|"CapabilitiesMoreAboutSection"|"CapabilitiesSeeAlsoSection"|"CapabilitiesRelatedFunctionsSection"|"CapabilitiesRelatedDemonstrationsSection"} :> 
Sequence[
  DIV[{"style"->"clear:both;"}, {"\[NonBreakingSpace]"}],
  DIV[{"class"->"LinksGroup"}, {
      Transmogrify[First[Cases[SelectChildren[],  ___, {2}]]],
      Transmogrify[Rest[Cases[SelectChildren[],  ___, {2}]]]
  }]
],

{Cell, "CapabilitiesRelatedLinksSection"|"CapabilitiesMoreAboutSection"|"CapabilitiesSeeAlsoSection"|"CapabilitiesRelatedFunctionsSection"|"CapabilitiesRelatedDemonstrationsSection"} :> 
  DIV[{"class" -> "LinksHeading"}, {Recurse[]}],

{Cell, "CapabilitiesRelatedLinks"|"CapabilitiesMoreAbout"|"CapabilitiesSeeAlso"|"CapabilitiesRelatedDemonstrations"} :> 
  DIV[{"class"->"Links"}, {Recurse[]}],

{Cell, "CapabilitiesRelatedFunctions"} :> Recurse[],


{CellGroupData, "CapabilitiesItem"} :>
Block[{sectionName, captionSource, caption},
  captionSource = First@First@SelectChildren[];
  caption = Recurse@captionSource;
  mainFileNameNumber++;

  sectionName = StringReplace[ DocumentationBuild`Utils`MakeCamelCaseString[captionSource], " "->""];
  Global`AntLog[ ToString[ {captionSource, sectionName} ]];

  DIV[{"class"->"itemHolder"}, { Recurse[]}]
],

{Cell, "CapabilitiesItem"} :>
  DIV[{"class"->"item"}, {Recurse[]}],

(****************************)


(** Input/Ouput Cell Groups **)
{CellGroupData, "Input" | "InputHiddenMaterial" | "InputSuppressedMaterial" | "InputThumbnailMaterial" | "InputPopupMaterial" | "InputMainPageMaterial" | "InputMainPopupMaterial"} :> 
Block[{style, showInput=True (*, labelClass="sessionLabel"*)},
  style = GetStyle[];
  Flatten@{
    Recurse@Cases[SelectLiteral@SelectSelf[], Cell[_, "calloutbox", ___], Infinity],
    DIV[{"class"->"example"}, Flatten@{
      Recurse@Cases[SelectLiteral@SelectSelf[], Cell[_, "Input"|"Output"|"InputHiddenMaterial" | "InputSuppressedMaterial" | "InputThumbnailMaterial" | "Graphics", ___], 5]
      }],
  Br[],
  Br[] 
  }
],

(*  Input / Output Images *)
{Cell, "Input" | "InputHiddenMaterial" | "InputThumbnailMaterial" | "InputPopupMaterial" | "InputMainPageMaterial" | "InputMainPopupMaterial"} :> 
Module[{iId,  iInner, iOuter, inputForm, inputFormQueue, isManipulate, style},

  style = GetStyle[];
  iNumber++;
  iId = StringJoin["i_", ToString@iNumber];
  iInner = StringJoin[iId, "_in"];
  iOuter = StringJoin[iId, "_out"];
  inputForm = CreateInputForm[ SelectSelf[] ];
  inputForm = If[Head@inputForm === String, inputForm, ToString@inputForm];
  inputFormQueue = inputQueue[inputForm, GetOption[CellLabel]];

  isManipulate = DocumentationBuild`Utils`IsManipulateQ[ SelectLiteral[SelectSelf[] ]];

Sequence@@Flatten@{  

DIV[{"class"->If[style === "InputPopupMaterial" || style === "InputHiddenMaterial", "inputState_Hide", "inputState"], "id"->"inGroup", "name"->"inGroup"}, {
XMLElement["table", {"class" -> "InCell"},  {  
    XMLElement["tr", {}, {

      (* cell label <td> *)
      XMLElement["td", {"class" -> "lab", "valign"->"top"}, 
Sequence@@{
     If[HasOption[CellTags],
       Flatten[ {   Map[
      (XMLElement["a", {"name" -> #}, {}])&, Flatten[{GetOption[CellTags]}]  
             ], 
        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
          { XMLElement["a", {
"name" -> "inoutlink", "href" -> "javascript:input('" <> iId <> "')",  "onmouseover"->" window.status=''; return true", "onmouseout"->"window.status=''; return true" 
            }, {DIV[{"class"-> labelClass, "id"->"inGroup", "name"->"inGroup"}, {GetOption[CellLabel]}], Br[], Img[{"src"->"/common/images2003/spacer.gif", "height"->"1", "width"->"65", "border"->"0", "alt"->""}] } ] }
          ,
          (* otherwise it's empty *)
          {}
        ] (* end If *)
               }],  

        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
          { XMLElement["a", {
"name" -> "inoutlink", "href" -> "javascript:input('" <> iId <> "')",  "onmouseover"->" window.status=''; return true", "onmouseout"->"window.status=''; return true" 
            }, {DIV[{"class"-> labelClass, "id"->"inGroup", "name"->"inGroup" }, {GetOption[CellLabel]}], Br[], Img[{"src"->"/common/images2003/spacer.gif", "height"->"1", "width"->"65", "border"->"0", "alt"->""}] } ] }
          ,
          (* otherwise it's empty *)
          {}
        ] (* end If *)

  ] 
}   (*  end sequence  *)
], (* end cell label <td> *) 
    
      (* input <td> *)
XMLElement["td", {"class" -> "Input", "valign"->"top"}, {

  DIV[{"class"->ToString@iNumber<>"_Ex", "name"->ToString@iNumber<>"_Ex", "id"->ToString@iNumber<>"_Ex"}, {XMLElement["a", { "href" -> "javascript:input('" <> iId <> "')",  "onmouseover"->" window.status=''; return true", "onmouseout"->"window.status=''; return true" }, {
  (* Check for Manipulate *) 
    If[isManipulate, 
    ( 
    Print["<"<>mainFileNameBase <> ": Manipulate Input cell>"]; 
    (* Do something with Input Manipulate? *)
    transmogrifyImage[ToFileName[{"HTMLImages", sectionName}, 
          "In_" <> IncrementCounter["iInner"] <> ".gif"],
          { "alt" -> "Click for copyable input", "border"->"0"},
          Inline -> True, CropImage -> False
      ]
      ), 
    ( 
    transmogrifyImage[ToFileName[{"HTMLImages", sectionName}, 
          "In_" <> IncrementCounter["iInner"] <> ".gif"],
      {"alt" -> "Click for copyable input", "border"->"0" },
          Inline -> True, CropImage -> False
     ]
    )
    ]
  }] }], (* end <div><a> *) 
  DIV[{"name" -> iOuter, "id" -> iOuter, "class"->"IFL"}, { 
    XMLElement["pre", {"name" -> iInner,  "id" -> iInner,  "class"->"IFT" }, {inputFormQueue}],
    DIV[{"class"->"IFU" }, { " " }]
  }]
  }] (* end <td> *) 
  }] (* end <tr> *) 

}] (* end <table> *)
}] (* end <div> *)
  }
], 

{Cell, "Output" | "Graphics" | "OutputSpecial" | "OutputOnly"} :> 
Module[{style, cTags, outCell, isManipulate, isSound, soundPath, soundID, soundExpr, manipulateExpr, ret, val, outputVals, outBase, width, height, flashID, swfPath, opts},

outCell = SelectLiteral[SelectSelf[] ];
style = GetStyle[];

cTags = Cases[outCell, Rule[CellTags, s_String] :> s, Infinity]; 
isManipulate = DocumentationBuild`Utils`IsManipulateQ[ outCell ] && !MemberQ[cTags, {"NoFlash"}];
isManipulate = If[style === "OutputSpecial", isManipulate = False, isManipulate];

isSound = DocumentationBuild`Utils`IsSoundQ[ outCell];


outputVals=First@Cases[ImageList[
      BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
    "Out_" <> IncrementCounter["Inline"] <> ".gif"],
    Inline -> True, CropImage -> False]
], _];
outBase=StringDrop[Cases[outputVals, "Baseline"~(Rule|RuleDelayed)~x_ -> x], -1];

If[
    HasOption[CellLabel] && StringMatchQ[GetOption[CellLabel], "*Form*" |"*Short*"],

  (* handle //*Form output *)
  XMLElement["table", {"class"->"OCell"}, {
    XMLElement["tr", {}, {
      XMLElement["td", {"colspan" -> "2"}, {
      (* this extra span just snags the inline styles from the celllabel
         block styles. width is overridden in the colspan="2" attribute *)
        XMLElement["div",{"class"->"celllabelTableForm"},
          If[ HasOption[CellLabel], {DIV[{"class"->labelClass, "id"->"inGroup", "name"->"inGroup"}, {GetOption[CellLabel]}], Br[], Img[{"src"->"/common/images2003/spacer.gif", "height"->"1", "width"->"65", "border"->"0"}] }, {} ]
        ]
      }] 
  }], (* end tr  *)
  
  XMLElement["tr", {}, {
      (* empty td for fixed width *)
    XMLElement["td", {"class" -> "lab"}, {" "}],
        XMLElement["td", {"class" -> "Output", "valign"->"top"}, { 
        (
           XMLElement["img", {
            "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
            "height" -> ("Height" /. #)
          }, {}]&[
            BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
              "O_" <> IncrementCounter["iOutput"] <> ".jpg"],
            Inline -> True, MaxImageSize->580, CropImage -> False, ImageFormat -> "JPEG", "CompressionLevel"->0]
          ]
    )
      }] (*  close td *)
    }] (*  close tr *)
  }] (*  close table *)
  ,

  (* otherwise handle normal output *)
  XMLElement["table", {"class"->"OCell"}, {
  XMLElement["tr", {}, {
      (* cell label <td> *)
      XMLElement["td", {"class" -> "lab"}, 
        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
          {DIV[{"class"->labelClass, "id"->"inGroup", "name"->"inGroup"}, {GetOption[CellLabel]}], Br[], Img[{"src"->"/common/images2003/spacer.gif", "height"->"1", "width"->"65", "border"->"0"}] }
          ,
          (* otherwise it's empty *)
          {}
        ] (* end If *)
      ], (* end cell label <td> *)


      XMLElement["td", {"class" -> "Output"}, {

        Which[
          (isManipulate && !DocumentationBuild`Transform`debug), (
            Print["<" <> GetFileNameBase[] <> ": Manipulate Output cell>"]; 
            flashID = "Flash_" <> IncrementCounter["flash"];
            swfPath = StringReplace[ToFileName[{"HTMLImages", GetFileNameBase[]}, flashID <> ".swf"],  {"\\" -> "/"}];
            opts = {"ShowControls" -> True, "ControlAppearance" -> Automatic,  "AnimationParameters"->Hold[val] };
            manipulateExpr = ReleaseHold@MakeExpression[First@outCell, StandardForm];
            ret = Export[swfPath, manipulateExpr, "SWF", Sequence@@opts];
            {width, height} = ImageSize /. val;
(*
            A[{"href"->"javascript:swap(this," <> ToString[width] <> "," <> ToString[height] <> ",'" <> swfPath <> "', '" <> flashID <> "')",  "onmouseover"->" window.status=''; return true", "onmouseout"->"window.status=''; return true"}, {
	          (*Span[{"class" -> "playAnimation"}, {"Play Animation ", XML`RawXML["&#9642;"]}],*)
              DIV[{"id"->flashID, "name"->flashID}, {
                transmogrifyImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False, "border"->"0"
            ]}]}]
*)
            A[{"title"->"Play animation", "href"->"javascript:swap(this," <> ToString[width] <> "," <> ToString[height] <> ",'" <> swfPath <> "', '" <> flashID <> "')",  
               "onmouseover"->" window.status=''; return true", "onmouseout"->"window.status=''; return true"}, {
             DIV[{"id"->flashID, "name"->flashID}, {
               XML`RawXML["<object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" 
                                   codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,0,0\" 
                                   width=\""<> ToString@width <>"\" 
                                   height=\""<> ToString@height <>"\" 
                                   id=\"benefits\" align=\"middle\"><param name=\"allowScriptAccess\" 
                                   value=\"sameDomain\" /><param name=\"movie\" value=\""<> swfPath <>"\" /><param name=\"loop\" 
                                   value=\"false\" /><param name=\"menu\" value=\"false\" /><param name=\"quality\" 
                                   value=\"high\" /><param name=\"bgcolor\" 
                                   value=\"#ffffff\" /><embed src=\""<> swfPath <>"\" loop=\"false\" menu=\"false\" 
                                   quality=\"high\" bgcolor=\"#ffffff\" width=\""<> ToString@width <>"\" height=\""<> ToString@height <>"\" 
                                   name=\"benefits\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" 
                                   pluginspage=\"http://www.macromedia.com/go/getflashplayer\" /></object>"]
             }] }]
             ), 
          isSound, (
            Print["<" <> GetFileNameBase[] <> ": Sound Output cell>"]; 
            soundID = "Sound_" <> IncrementCounter["sound"];
            soundPath = StringReplace[ToFileName[{"HTMLImages", GetFileNameBase[]}, soundID <> ".wav"],  {"\\" -> "/"}];
            soundExpr = Sound@@Cases[First@SelectLiteral[SelectChildren[]], _Sound, Infinity];
            ret = Export[soundPath, soundExpr];
            A[{"href"->soundPath}, {
	          (*Span[{"class" -> "playSound"}, {"Play Sound ", XML`RawXML["&#9642;"]}],*)
              DIV[{"id"->soundID}, {
                transmogrifyImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
                  IncrementCounter["Image"] <> ".gif"],
                  Inline -> True, CropImage -> False
            ]}]}] ), 
          True, (
            transmogrifyImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
              "O_" <> IncrementCounter["iOutput"] <> ".jpg"],
              Inline -> True, (*MaxImageSize->580,*) CropImage -> False, ImageFormat -> "JPEG", "CompressionLevel"->0] )
       ] 

    }] (* end Output <td> *)

    }] (*  close tr  *)  
  }] (*  close table  *) 
] ], (* end "Output" rule *)




(****************************)

{Cell, All} :> 
  DIV[{"class" -> "text"}, { Recurse[] }]



}, 

IncludeXMLTransforms -> {{"HTML","Components","Includes.m"}},
DefaultParameters -> { "newline2br" -> False, "newline2div" -> False}

]
