(* :Title: Functions.m *)

(* :Author:
	Andrew Hunt, andy@wolfram.com
	Greg Martel, gregm@wolfram.com
*)

(* :Mathematica Version: 5 *)
(* :Package Version: $Revision: 1.7 $ $Date: 2016/05/31 19:35:59 $ *)                  
(* :Copyright: (c) 2005, Wolfram Research, Inc. All rights reserved. *)
(* :Summary: Add-ons specific rules and general transform for Mathematica Documentation *)


XMLTransform[{

{Notebook} :> 
WithParameters[
  { (* "FileName"-> StringReplace[GetAbsoluteFileName[], {".en"->"", ".ja"->""}],  *)
  		
   		"FileName"-> StringReplace[GetFileNameBase[], {".en"->"", ".ja"->""} ],
		"prev" -> (PrevLink /. Cases[
				Cases[GetParameter["properties"], __],
 				_~(Rule|RuleDelayed)~_]),  
		"next" -> (NextLink /. Cases[
				Cases[GetParameter["properties"], __],
 				_~(Rule|RuleDelayed)~_]), 
		"titlename" ->First[Cases[GetParameter["properties"], __]],
		"linkTrail" -> (LinkTrail /. Cases[
				Cases[GetParameter["properties"], __],
 				_~(Rule|RuleDelayed)~_]), 
		"linkTrailSeperator" -> XMLElement["img", {"src" -> 
			"/common/images2003/linktrail-separator.gif", "border" -> "0", "width" -> "10", 
			"height" -> "10", "alt" -> " / ", "hspace" -> "3"}, {}], 
		"linkTrailPath" -> First[Last[(LinkTrail /. Cases[
					Cases[GetParameter["properties"], __],
					_~(Rule|RuleDelayed)~_])]],
		"AppName" -> First[First[(LinkTrail /. Cases[
				Cases[GetParameter["properties"], __], 
				_~(Rule|RuleDelayed)~_])]]
				
  
  }, 
  
  Print[GetParameter["FileName"]];
  Print[GetParameter["properties"]];

(
  
Block[{},

Export[
  StringJoin[GetFileNameBase[], ".html-head"],
  XML`RawXML[ StringJoin[ExportString[#, "XML"] & /@ 
	Flatten[  {
		XMLElement["title", {}, {GetParameter["FileName"]}],
		XMLElement["meta", 
          {
            "name"->"keywords", 
            "content"->StringList[GetParameter["keywords"]]
          }, {}
        ]
	}   ]  
  ]]
  , "XML"];
  
    
  (* fill in layout file with content *)
  (* symbolic XML template *)
 FillInLayout[
    GetParameter["layoutfile"],
    "Text",    
    "ProdName"-> ExportString[XMLElement["a", {"href" -> GetParameter["AppName"]}, {
				XMLElement["img", {"src" -> GetParameter["AppName"] <> "images/productName.gif",
					"border" -> "0" }, {}]   }], "XML", "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, 
					"ElementFormatting" -> DocumentationBuild`DocumentationConversion`Private`indentFunction], 
					
	"LinkTrailDiv"-> ExportString[XMLElement["table", {"border"->"0", "cellpadding"->"0", 
			"cellspacing"->"0", "width" -> "100%"}, {
			XMLElement["tr", {}, {
			XMLElement["td", {"align" -> "left"}, {
			XMLElement["div", {"class" -> "LinkTrailDiv"}, Sequence@@{
				Flatten[{ 
				Map[{XMLElement["a", {"class" -> "LinkTrailLink", 
					"href" -> #[[1]]  /. GetParameter["urlRedirectRules"]} , {#[[2]]} ],
									GetParameter["linkTrailSeperator"]} &, 
									 Rest[GetParameter["linkTrail"]]  ]     
							 }]   }]     }],
			XMLElement["td", {"align" -> "right", "style" -> "vertical-align:top"}, {
				"\n\n",
				XMLObject["Comment"]["Begin previous-next"],
				"\n",
				XMLElement["a", {"href" -> StringJoin[GetParameter["prev"], 
					".html"] /. GetParameter["urlRedirectRules"], 
					"onmouseover" -> "MM_swapImage('previous','','/images/previous_Arrow-over.gif',1);", 
					"onmouseout" -> "MM_swapImgRestore();"}, {
					XMLElement["img", {"src" -> 
						"/images/previous_Arrow.gif", "border" -> "0", "width" -> "19", "height" -> 						"19", "name" -> "previous", "id" -> "previous", "alt" -> "Previous section"
					}, {}] }],
				XMLElement["img", {"src" -> 
					"/images/divider-line.gif", "border" -> "0", "width" -> "5", "height" -> "19", 						"alt" -> "-----"}, {}], 
				XMLElement["a", {
					"href" -> StringJoin[GetParameter["next"], ".html"] /. GetParameter									["urlRedirectRules"], 
					"onmouseover" -> "MM_swapImage('next','','/images/next_Arrow-over.gif',1)", 
					"onmouseout" -> "MM_swapImgRestore();"}, {
					XMLElement["img", {"src" -> 
						"/images/next_Arrow.gif", "border" -> "0", "width" -> "19", "height" -> "19", 					"name" -> "next", "id" -> "next", "alt" -> "Next section"}, {}]
				}],
				"\n\n",
				XMLObject["Comment"]["End previous-next"],
				"\n"

				}]

				}]
				}], "XML", "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"}, 
					"ElementFormatting" -> DocumentationBuild`DocumentationConversion`Private`indentFunction],
   
    "bodystyle" -> ExportString[XML`RawXML["<div class=\"MainRoot\" width = \"727\">"], "XML"],  

    "body"->
      ExportString[
XMLElement["td", {"id"-> "ApplicationTable"}, { Recurse[] }],
        "XML",
     "AttributeQuoting"->"\"", "Entities"->{"\[LongDash]"->"&mdash;"},    
"ElementFormatting" -> DocumentationBuild`DocumentationConversion`Private`indentFunction] 


]  
  ]
)
],  (* end WithParam *)



(* Remove in-product decorations *)
{Cell, "LinkTrail" | "AnchorBar" | "History" | "HistoryData" | "AnchorBarGrid"} :> "", 

{Cell, "Usage"} :> 
	(* DIV[{"id" -> "UT"}, { *) 
	DIV[{"id" -> "UsageTable"}, { 
		(* DIV[{"class" -> "UM"}, { *) 
		DIV[{"class" -> "UsageMessage"}, { WithParameters[{"newline2div" -> True}, Recurse[] ] }] } ], 


{Cell, "BulletText" | "BulletedList"} :>
(* DIV[{"id" -> "BulletedList"}, {Recurse[]} ], *)
UL[{"id" -> "BulletedList"}, {
Li[{}, {Recurse[]} ]
}], 


{Cell, "CompactText"} :>
WithParameters[{"newline2div" -> True}, 
DIV[{"class" -> "SmallText"}, {Recurse[]}]
],


{Cell, "Contents"} :>
WithParameters[{"newline2div" -> True, 	"styleUsageMessageBreak" -> "</div>\n<div class=\"Contents\">"}, 
DIV[{"class" -> "Contents"}, {Recurse[]}]
],


{Cell, "MathCaption"} :>
XMLElement["div", {"class" -> "MathCaption"}, 
  If[HasOption[CellTags],
  Flatten[ {
    Map[
    (XMLElement["a", {"name" -> #}, {}])&, Flatten[{GetOption[CellTags]}] ],
    Recurse[]  }],
  {Recurse[]}  ]    
],


{Cell, "References"} :>
WithParameters[{"newline2div" -> True, 	"styleUsageMessageBreak" -> "</div>\n<div class=\"References\">"}, 
DIV[{"class" -> "References"}, {Recurse[]}]
],



{Cell, "Text"} :> WithParameters[{"newline2div" -> True, 	"styleUsageMessageBreak" -> "</div>\n<div class=\"Text\">"}, 
DIV[{"class" -> "Text"}, {Recurse[]} ]
],


{Cell, "ItemizedText" | "ItemizedList" | "ItemizedSubList"} :>
(* DIV[{"id" -> "ItemizedList"}, {Recurse[]}],  *)
UL[{"id" -> "BulletedList"}, {
Li[{}, {Recurse[]} ]
}], 


(* {Cell, "ItemizedText" | "ItemizedList" | "ItemizedSubList"} :>
Module[{content},
content = SelectChildren[];

If[MatchQ[content[[1,1,1]], StyleBox[s_/;StringMatchQ[s,RegularExpression["\\d+\\."]],_]],  
	DIV[{"id" -> "ItemizedList"}, {Transmogrify[content]}], 
	Li[{"id" -> "ItemizedList"}, {Transmogrify[content]}] 
	]
], *)



{Cell, "NumberedEquation" | "DisplayFormula"} :> 
DIV[{"class" -> GetStyle[]} , {
( XMLElement["img", {
		"src" -> ("URL" /. #),  
		"width" -> ("Width" /. #), "height" -> ("Height" /. #), "alt" -> " "
	}, {}]&[BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
		GetFileNameBase[] <> "_ne_" <> IncrementCounter["NumberedEquation"] <> ".gif"],
	(*	Inline -> True]])  *)
		Inline -> False]])   (* changed for TimeSeries--why inline anywahy?  *)
}],  


{Cell, "DisplayMath"} :> 
DIV[{"class" -> GetStyle[]} , {
( XMLElement["img", {
		"src" -> ("URL" /. #),  
		"width" -> ("Width" /. #), "height" -> ("Height" /. #), "alt" -> " "
	}, {}]&[BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
		GetFileNameBase[] <> "_ne_" <> IncrementCounter["NumberedEquation"] <> ".gif"],
		Inline -> False]])
}],  


{Cell, "Chapter"} :> H1[{"class"-> "Chapter"}, {Recurse[]}], 


{Cell, "TOCSection"} :> DIV[{"class"-> "ContentsSection"}, {
XMLElement["b", {}, {Recurse[]}]
}], 

{Cell, "TOCSubsection"} :> DIV[{"class"-> "ContentsSubsection"}, {Recurse[]}], 

{Cell, "TOCSubsubsection"} :> DIV[{"class"-> "ContentsSubsubsection"}, {Recurse[]}], 

{Cell, "TOCPage"} :> Span[{"class"-> "TOCPage"}, {Recurse[]}], 

{Cell,  "2ColumnTable" | "3ColumnTable"} :>
DIV[{"class" -> "FunctionTable", "name"-> GetStyle[]}, {Recurse[]}], 

{Cell,  "AlphabeticalListingTable"} :> P[{"class" -> "MathTable", "name"-> GetStyle[]}, {Recurse[]}],

{Cell, "BulletedSubList"} :>
DIV[{"class" -> "BulletedSubList"}, {Recurse[]}], 

{CellGroupData, "TopBox" | "TopSpanBox"} :>
DIV[{"class" -> "MathTable"}, {Recurse[]}], 	

{Cell, "TopBox" | "TopSpanBox"} :>
DIV[{"class" -> "TopBox"}, {Recurse[]}], 

{Cell, "MiddleBox" | "MiddleSpanBox"} :>
DIV[{"class" -> "MiddleBox"}, {Recurse[]} ],

{Cell, "BottomBox"} :>
DIV[{"class" -> "BottomBox"}, {Recurse[]}],


(***** Cell Definitions *****)
{Cell, "Notes"} :> XMLElement["div", {"class" -> "Notes"}, {Recurse[]} ],


{Cell, "Picture"} :> {
(XMLElement["img", {
		"src" -> GetParameter["linkTrailPath"] <> ("URL" /. #),
		"width" -> ToString[Floor[.89 ToExpression["Width" /. #]]],
		"height" -> ToString[Floor[.89 ToExpression["Height" /. #]]], "alt" -> " "
	}, {}]&[BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
		GetFileNameBase[] <> "_pict_" <> IncrementCounter["Picture"] <> ".gif"],
		Inline -> True]])
}, 


{Cell, "Graphics"} :>
XMLElement["p", {"class" -> GetStyle[]}, {
		XMLElement["img", {
			"src" -> ("URL" /. #),
			"width" -> ("Width" /. #), "height" -> ("Height" /. #), "alt" -> " "
		}, {}]&[BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
			GetFileNameBase[] <> "_a_" <> IncrementCounter["Animation"] <> ".gif"],
			Inline -> False ]]
}],


{CellGroupData, "PictureGroup" | "Graphics"} :>
(If[HasOption[First[SelectChildren[Cell]], AnimationCycleRepetitions],
	XMLElement["p", {"class" -> "Animation"}, {
		WithParameters[{"src" -> ToFileName[{"HTMLImages", GetFileNameBase[]},
				GetFileNameBase[] <> "_a_" <> IncrementCounter["Animation"] <> ".gif"]},
			CreateDirectory[DirectoryName[GetParameter["src"]]];
			Export[GetParameter["src"],
				SelectLiteral[SelectChildren[]], "GIF", 
				ConversionOptions -> {"Loop" -> 3}];
			XMLElement["img", {
				"src" -> StringReplace[GetParameter["src"], $PathnameSeparator -> "/"]
			}, {}]
		]
	}],
	XMLElement["p", {"class" -> GetStyle[]}, {
		XMLElement["img", {
			"src" -> ("URL" /. #),
			"width" -> ("Width" /. #), "height" -> ("Height" /. #), "alt" -> " "
		}, {}]&[BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
			GetFileNameBase[] <> "_a_" <> IncrementCounter["Animation"] <> ".gif"],
			Inline -> False ]]
}]]), 



{CellGroupData, "Input"} :> 
  DIV[{"class"->"inoutdiv"}, {Recurse[]}],


{Cell, "FlushInput" | "Input" | "InputOnly"} :>	
Sequence@@{
  XMLElement["table", {"class" -> "InputCell"
  }, {
    XMLElement["tr", {}, {
      XMLElement["td", {"class" -> "celllabel"}, 
        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
		{GetOption[CellLabel]},
          {" "} ] (* otherwise it's empty end If *)
      ], 
      (* input <td> *)
      TD[{"class" -> "Input"}, {
          ( 
            XMLElement["img", {
              "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
              "height" -> ("Height" /. #), 
              "alt" -> " " 
            }, {}]&[
              BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
                GetFileNameBase[] <> "_i_" <> IncrementCounter["Input"] <> ".gif"],
                  Inline -> True]
            ]
          ) } ] (* end <td> *)
    }]  (* end <tr> *)
  }] (* end <table> *)
},  


{Cell, "Output"} :>	
Sequence@@{
  XMLElement["table", {"class" -> "OutputCell"
  }, {
    XMLElement["tr", {}, {
      XMLElement["td", {"class" -> "celllabel"}, 
        If[HasOption[CellLabel],
          (* fill it with the CellLabel text *)
		{GetOption[CellLabel]},
          {" "} ] (* otherwise it's empty end If *)
      ], 
      (* output <td> *)
      TD[{"class" -> "Output"}, {
          ( 
            XMLElement["img", {
              "src" -> ("URL" /. #), "width" -> ("Width" /. #), 
              "height" -> ("Height" /. #), 
              "alt" -> " " 
            }, {}]&[
              BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
                GetFileNameBase[] <> "_i_" <> IncrementCounter["Input"] <> ".gif"],
                  Inline -> True]
            ]
          ) } ] (* end <td> *)
    }]  (* end <tr> *)
  }] (* end <table> *)
},  



{RawData} :> ( 
XMLElement["img", {
		"src" -> GetParameter["linkTrailPath"] <> ("URL" /. #),
		"width" -> ("Width" /. #), "height" -> ("Height" /. #), "alt" -> " "
	}, {}]&[BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
		GetFileNameBase[] <> "_" <> IncrementCounter["GraphicsData"] <> ".gif"],
		Inline -> True]]),  


{Cell, "MR"} :> Span[{"class"->"MR"}, {Recurse[]}],


{StyleBox, "MR"} :> Module[ { output , replacements},
output = Recurse[]; 
replacements = Import[
ToFileName[{DocumentationBuild`Common`$DocumentationBuildDirectory, "Internal", "web", "data"}, "MRReplacementList.m"]
 ];

WithParameters[ { "url"->( output /.  replacements )}, 

If[
Head[ GetParameter["url"] ] === XMLElement,  
GetParameter["url"],
  Span[{"class" -> "MR"}, {output} ] ]  
  ]
], 




{ButtonBox} :> Block[
{BoxContent, BoxButtonData, RawBoxOptions, BoxOptions, exampleReplacements},

exampleReplacements = Import[
ToFileName[{$UserAddOnsDirectory, "Applications", "DocumentationBuild", "Internal", "web", "data"}, "ApplicationsButtonReplacements.m"] 
]; 

BoxContent := Recurse[];
BoxButtonData = Switch[GetOption[ButtonData],
	URL[_], GetOption[ButtonData][[1]],
	{URL[_], _}, GetOption[ButtonData][[1, 1]],
	{___, _String?((StringLength[#] >= 3 && StringTake[#, {-3,-1}] == ".nb")&)},
		Last[GetOption[ButtonData]],
	_String?((StringTake[#, {-3,-1}] == ".nb")&), GetOption[ButtonData],
	{___, _String}, If[StringSplit[GetParameter["AppName"], "/"][[2]] === "timeseries" && Length@GetOption[ButtonData] == 2, 
		First@GetOption[ButtonData] <> ".html" <> "#" <> Last@GetOption[ButtonData],  
		Last@GetOption[ButtonData] <> ".html"],
(*	{___, _String}, Last@GetOption[ButtonData] <> ".html",  *)
	_String, GetOption[ButtonData] <> ".html",
	{FrontEnd`FileName[{__}, file_String, ___], ___}, StringReplace[GetOption[ButtonData][[1, 2]], ".nb"->""] <> ".html",
	{FrontEnd`FileName[{}, file_String, ___], ___}, StringReplace[GetOption[ButtonData][[1, 2]], ".nb"->""] <> ".html",
	{_String, None}, GetOption[ButtonData][[1]],
	_,  "FIXME"]; 
BoxButtonData = ( BoxButtonData /. exampleReplacements ); 
BoxButtonData = StringReplace[BoxButtonData, exampleReplacements];


RawBoxOptions =  Rest@Cases[SelectSelf[], _];
BoxOptions = Which[
	MemberQ[RawBoxOptions, _ -> "MainBookLink"], "href" -> "/language/tutorial/" <> BoxContent,   
	MemberQ[RawBoxOptions, _ -> "RefGuideLink"], "href" -> "/language/ref/" <> BoxContent,   
	MemberQ[RawBoxOptions, _ -> "Hyperlink"], "href" -> BoxButtonData ,   
	MemberQ[RawBoxOptions, _ -> "AddOnsLinkText"], "href" -> BoxButtonData ,   
	MemberQ[RawBoxOptions, _ -> "AddOnsLink"], "href" -> BoxButtonData ,   
	GetOption[ButtonData] == None && StringMatchQ[ToString[GetOption[ButtonEvaluator]], "Automatic"], 
		"href" -> StringReplace[Transmogrify[SelectChildren[][[1]]], " " -> ""] <> ".tar.gz",
	GetOption[ButtonData] == None && StringMatchQ[ToString[GetOption[ButtonFunction]], "NotebookOpen*"], 
		{NBOPEN = GetOption[ButtonFunction];  
     		CopyFile[NBOPEN[BoxContent], StringDrop[BoxContent, -3] <> "2.nb"];,   
		"href" -> BoxContent},
	True, "href" -> BoxButtonData ];

Which[
	MatchQ[GetOption[ButtonStyle], "UserDocsLink" | "PageLink"], Recurse[], 
	True, A[{BoxOptions}, {BoxContent}]
	]
],



(* {ButtonBox} :> Block[
{BoxContent, BoxButtonData, RawBoxOptions, BoxOptions, exampleReplacements},

exampleReplacements = Import[
ToFileName[{$UserAddOnsDirectory, "Applications", "DocumentationBuild", "Internal", "web", "data"}, "ApplicationsButtonReplacements.m"] 
]; 

BoxContent := Recurse[];
BoxButtonData = Switch[GetOption[ButtonData],
	URL[_], GetOption[ButtonData][[1]],
	{URL[_], _}, GetOption[ButtonData][[1, 1]],   
	{___, _String?((StringLength[#] >= 3 && StringTake[#, {-3,-1}] == ".nb")&)},
		Last[GetOption[ButtonData]],
	_String?((StringTake[#, {-3,-1}] == ".nb")&), GetOption[ButtonData],
	{___, _String}, Last@GetOption[ButtonData] <> ".html",  
	_String, GetOption[ButtonData] <> ".html",
	{FrontEnd`FileName[{__}, file_String, ___], ___}, StringReplace[GetOption[ButtonData][[1, 2]], ".nb"->""] <> ".html",
	{FrontEnd`FileName[{}, file_String, ___], ___}, StringReplace[GetOption[ButtonData][[1, 2]], ".nb"->""] <> ".html",
	{_String, None}, GetOption[ButtonData][[1]],
	_,  "FIXME"]; 
BoxButtonData = ( BoxButtonData /. exampleReplacements ); 

RawBoxOptions =  Rest@Cases[SelectSelf[], _];
BoxOptions = Which[
	MemberQ[RawBoxOptions, _ -> "MainBookLink"], "href" -> "/language/tutorial/" <> BoxContent,   
	MemberQ[RawBoxOptions, _ -> "RefGuideLink"], "href" -> "/language/ref/" <> BoxContent,   
	MemberQ[RawBoxOptions, _ -> "Hyperlink"], "href" -> BoxButtonData ,   
	MemberQ[RawBoxOptions, _ -> "AddOnsLinkText"], "href" -> BoxButtonData ,   
	MemberQ[RawBoxOptions, _ -> "AddOnsLink"], "href" -> BoxButtonData ,   
	GetOption[ButtonData] == None && StringMatchQ[ToString[GetOption[ButtonEvaluator]], "Automatic"], 
		"href" -> StringReplace[Transmogrify[SelectChildren[][[1]]], " " -> ""] <> ".tar.gz",
	GetOption[ButtonData] == None && StringMatchQ[ToString[GetOption[ButtonFunction]], "NotebookOpen*"], 
		{NBOPEN = GetOption[ButtonFunction];  
     		CopyFile[NBOPEN[BoxContent], StringDrop[BoxContent, -3] <> "2.nb"];,   
		"href" -> BoxContent},
	True, "href" -> BoxButtonData ];

Which[
	StringSplit[GetParameter["AppName"], "/"][[2]] === "timeseries" && MatchQ[GetOption[ButtonData], {a_String, b_String}], Print@"FIRST ONE"; Recurse[], 
	MatchQ[GetOption[ButtonStyle], "UserDocsLink" | "PageLink"], Print@"Second ONE"; Recurse[], 

	True, Print@"Third ONE";A[{BoxOptions}, {BoxContent}]
	]
],  *)






{Cell, None} :> If[htmlBoxesQ[ SelectLiteral[ SelectSelf[] ] ], 
  Recurse[], 
transmogrifyImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
    "Box_" <> IncrementCounter["Inline"] <> ".gif"],
    {alt -> ""}, 
     Inline -> True, CropImage -> False]
     ],
     



(* {Cell, None} :>
If[
  htmlBoxesQ[ SelectLiteral[ SelectSelf[] ] ], 
  Transmogrify[ SelectChildren[] ],
  (  
    XMLElement["img", { 
      "class" -> "FlushInput", "src" -> ("URL" /. #), 
      "width" -> ("Width" /. #), "height" -> ("Height" /. #),  
      "alt" -> " "  }, {}]&[
      BoxToImage[ToFileName[{"HTMLImages", GetFileNameBase[]},
    "Box_" <> IncrementCounter["Inline"] <> ".gif"],
    Inline -> True, CropImage -> False]
    ]
  )  
],   *)



{OutputFormData} :> Transmogrify[SelectChildren[][[2]]]

},

IncludeXMLTransforms -> {{"HTML","Components","Defaults.m"}, {"HTML","Components","GridBox.m"}, {"HTML","Components","StyleBox.m"}, {"HTML","Components","ButtonBox.m"}},

DefaultParameters -> {
	(*  "newline2br" -> False,  *)
	"newline2br" -> False,
	"newline2div" -> False,
	"styleUsageMessageBreak" -> "</div>\n<div class=\"UsageMessage\">",

	(* No Operation code *)
	"noop" -> {
		$CreateCompleteHTMLFile = False;
		$LanguageExtension = "en";

		(* routines for graphic popup *)
		largeImageQ[w___]:= False;
		largeImageQ[{w_, h_}, n_]:=
			If[(w > n) || (h > n), True, False];

		thumbnailImageSize[w_, h_, n_]:=
			Block[{mag},
				If[w > h,
					mag = N[n/w];
					{"width" -> ToString[Ceiling[mag*w]], "height" -> ToString[Ceiling[mag*h]]}
				,
					mag = N[n/h];
					{"width" -> ToString[Ceiling[mag*w]], "height" -> ToString[Ceiling[mag*h]]}
				]
			];

	}
},

CounterReassignments -> {{"Chapter", "Section"}, {"Section", "Subsection"}, {"Subsection", "Subsubsection"}}

]
