(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9017,        229]
NotebookOptionsPosition[      8243,        200]
NotebookOutlinePosition[      8585,        215]
CellTagsIndexPosition[      8542,        212]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
   "applicationsDir", "=", 
    "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspace\\\\DocumentationToolsDevel\\\\\>\""}], ";", 
   "\n", 
   RowBox[{"PrependTo", "[", 
    RowBox[{"$Path", ",", "applicationsDir"}], "]"}], ";", "\n", 
   RowBox[{"<<", "DocumentationTools`"}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.35690189997057*^9, 3.3569019006112*^9}, {
   3.36413094908612*^9, 3.36413095488311*^9}, {3.384607896397517*^9, 
   3.3846078994444313`*^9}, {3.3862783476994576`*^9, 3.3862783483244658`*^9}, 
   3.387635755589958*^9, {3.40000373444059*^9, 3.4000037369093714`*^9}, {
   3.400193725244195*^9, 3.4001937260098295`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "guidesDir", "=", 
   "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspace\\\\MathematicaDocumentationDEVEL\\\\\
Documentation\\\\English\\\\System\\\\Guides\\\\\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.400196903628628*^9, 3.4001969101755867`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"files", "=", 
   RowBox[{"FileNames", "[", 
    RowBox[{"\"\<*.nb\>\"", ",", "guidesDir"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.400197699232561*^9, 3.4001977162015285`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", "files"}]], "Input",
 CellChangeTimes->{{3.4001979104071393`*^9, 3.4001979128915462`*^9}}],

Cell[BoxData["325"], "Output",
 CellChangeTimes->{3.4001979138915586`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "file", "=", 
   "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspace\\\\MathematicaDocumentationDEVEL\\\\\
Documentation\\\\English\\\\System\\\\ReferencePages\\\\Symbols\\\\GraphData.\
nb\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.370360150553095*^9, 3.3703601676622515`*^9}, {
   3.3858979908815956`*^9, 3.3858980133036137`*^9}, {3.3858980532569947`*^9, 
   3.385898055803886*^9}, 3.3858982186643033`*^9, 3.3858982718833942`*^9, 
   3.3858983553995533`*^9, {3.3864371028878365`*^9, 3.3864371119973283`*^9}, 
   3.386437470095662*^9, {3.3876850949246187`*^9, 3.3876851000965595`*^9}, {
   3.3996566864314346`*^9, 3.3996566894783487`*^9}, {3.399830147507306*^9, 
   3.3998301646012754`*^9}, 3.400000142941494*^9, {3.400196932503997*^9, 
   3.4001969438947678`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", "=", 
   RowBox[{"guidesDir", "<>", "\"\<Mathematica.nb\>\""}]}], ";"}]], "Input",
 CellChangeTimes->{{3.370360150553095*^9, 3.3703601676622515`*^9}, {
   3.3858979908815956`*^9, 3.3858980133036137`*^9}, {3.3858980532569947`*^9, 
   3.385898055803886*^9}, 3.3858982186643033`*^9, 3.3858982718833942`*^9, 
   3.3858983553995533`*^9, {3.3864371028878365`*^9, 3.3864371119973283`*^9}, 
   3.386437470095662*^9, {3.3876850949246187`*^9, 3.3876851000965595`*^9}, {
   3.3996566864314346`*^9, 3.3996566894783487`*^9}, {3.399830147507306*^9, 
   3.3998301646012754`*^9}, 3.400000142941494*^9, {3.4001880107648*^9, 
   3.400188020624302*^9}, {3.4001968977066765`*^9, 3.400196922425743*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", "=", 
   RowBox[{"guidesDir", "<>", "\"\<AlgebraicNumberTheory.nb\>\""}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.370360150553095*^9, 3.3703601676622515`*^9}, {
   3.3858979908815956`*^9, 3.3858980133036137`*^9}, {3.3858980532569947`*^9, 
   3.385898055803886*^9}, 3.3858982186643033`*^9, 3.3858982718833942`*^9, 
   3.3858983553995533`*^9, {3.3864371028878365`*^9, 3.3864371119973283`*^9}, 
   3.386437470095662*^9, {3.3876850949246187`*^9, 3.3876851000965595`*^9}, {
   3.3996566864314346`*^9, 3.3996566894783487`*^9}, {3.399830147507306*^9, 
   3.3998301646012754`*^9}, 3.400000142941494*^9, {3.4001880107648*^9, 
   3.400188020624302*^9}, {3.400196520779977*^9, 3.400196524139395*^9}, {
   3.4001969576136937`*^9, 3.400196975863927*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"NotebookOpen", "@", "file"}], ";"}]], "Input",
 CellChangeTimes->{{3.4000092023375783`*^9, 3.400009208525158*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"DocumentationTools`Navigation`$Pages", "=", 
   RowBox[{
   "DocumentationTools`Navigation`ComputeLinkTrails", "[", "guidesDir", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.4001969826765146`*^9}],

Cell[BoxData[
 RowBox[{"ExportWebPage", "[", 
  RowBox[{
   RowBox[{"\"\<E:\\\\documentation.w.c\\\\tmp\\\\\>\"", "<>", 
    RowBox[{"StringReplace", "[", 
     RowBox[{"file", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"DirectoryName", "[", "file", "]"}], "\[Rule]", "\"\<\>\""}],
         ",", 
        RowBox[{"\"\<.nb\>\"", "\[Rule]", "\"\<\>\""}]}], "}"}]}], "]"}], 
    "<>", "\"\<.html\>\""}], ",", "file", ",", 
   RowBox[{"NotebookPageType", "@", 
    RowBox[{"NotebookEntityType", "@", "file"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3796941689031467`*^9, 3.3796941774501314`*^9}, {
   3.379694402593638*^9, 3.3796944043592854`*^9}, {3.3835777286631165`*^9, 
   3.383577729835006*^9}, {3.3846279199306774`*^9, 3.3846279222413273`*^9}, {
   3.3846366098966684`*^9, 3.3846366102567015`*^9}, {3.3864098725944214`*^9, 
   3.3864098741254654`*^9}, {3.3864334696963377`*^9, 3.386433471524486*^9}, 
   3.3864371268725185`*^9, 3.386635837772066*^9, 3.386710093362075*^9, {
   3.3867612348329153`*^9, 3.386761238286085*^9}, {3.386812786800637*^9, 
   3.3868127877068987`*^9}, {3.387073059762717*^9, 3.3870730625440025`*^9}, {
   3.387685121690586*^9, 3.3876851253156323`*^9}, 3.3876860854060464`*^9, {
   3.399656702244137*^9, 3.3996567030722723`*^9}, {3.3998301843359027`*^9, 
   3.3998302363365684`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Print", "[", "#", "]"}], ";", 
      RowBox[{"ExportWebPage", "[", 
       RowBox[{
        RowBox[{
        "\"\<E:\\\\documentation.w.c\\\\tmp\\\\guides\\\\\>\"", "<>", 
         RowBox[{"StringReplace", "[", 
          RowBox[{
           RowBox[{"Part", "[", 
            RowBox[{"files", ",", "#"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"DirectoryName", "[", "file", "]"}], "\[Rule]", 
              "\"\<\>\""}], ",", 
             RowBox[{"\"\<.nb\>\"", "\[Rule]", "\"\<\>\""}]}], "}"}]}], "]"}],
          "<>", "\"\<.html\>\""}], ",", 
        RowBox[{"Part", "[", 
         RowBox[{"files", ",", "#"}], "]"}], ",", 
        RowBox[{"NotebookPageType", "@", 
         RowBox[{"NotebookEntityType", "@", 
          RowBox[{"Part", "[", 
           RowBox[{"files", ",", "#"}], "]"}]}]}]}], "]"}]}], ")"}], "&"}], "/@",
    
   RowBox[{"Reverse", "@", 
    RowBox[{"Range", "@", 
     RowBox[{"Length", "@", "files"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3796941689031467`*^9, 3.3796941774501314`*^9}, {
   3.379694402593638*^9, 3.3796944043592854`*^9}, {3.3835777286631165`*^9, 
   3.383577729835006*^9}, {3.3846279199306774`*^9, 3.3846279222413273`*^9}, {
   3.3846366098966684`*^9, 3.3846366102567015`*^9}, {3.3864098725944214`*^9, 
   3.3864098741254654`*^9}, {3.3864334696963377`*^9, 3.386433471524486*^9}, 
   3.3864371268725185`*^9, 3.386635837772066*^9, 3.386710093362075*^9, {
   3.3867612348329153`*^9, 3.386761238286085*^9}, {3.386812786800637*^9, 
   3.3868127877068987`*^9}, {3.387073059762717*^9, 3.3870730625440025`*^9}, {
   3.387685121690586*^9, 3.3876851253156323`*^9}, 3.3876860854060464`*^9, {
   3.399656702244137*^9, 3.3996567030722723`*^9}, {3.3998301843359027`*^9, 
   3.3998302363365684`*^9}, {3.400197784733656*^9, 3.400197900235134*^9}}],

Cell[BoxData["\<\"E:\\\\documentation.w.c\\\\tmp\\\\AlgebraicNumberTheory.en.\
html\"\>"], "Output",
 CellChangeTimes->{3.400196627875098*^9, 3.400197603450085*^9}]
}, Open  ]]
},
WindowSize->{1242, 646},
WindowMargins->{{Automatic, 12}, {Automatic, 23}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (June 14, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 692, 15, 72, "Input"],
Cell[1263, 38, 295, 7, 31, "Input"],
Cell[1561, 47, 220, 5, 31, "Input"],
Cell[CellGroupData[{
Cell[1806, 56, 128, 2, 31, "Input"],
Cell[1937, 60, 74, 1, 30, "Output"]
}, Open  ]],
Cell[2026, 64, 811, 15, 31, "Input"],
Cell[2840, 81, 724, 11, 31, "Input"],
Cell[3567, 94, 787, 13, 31, "Input"],
Cell[4357, 109, 149, 3, 31, "Input"],
Cell[4509, 114, 238, 6, 31, "Input"],
Cell[4750, 122, 1345, 25, 52, "Input"],
Cell[CellGroupData[{
Cell[6120, 151, 1940, 42, 52, "Input"],
Cell[8063, 195, 164, 2, 30, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
