(* I'm not sure yet what sorts of comments or packaging we need here. *)

BeginPackage["UnitTests.m`", {"Transmogrify`", "AuthorTools`"}];

(*********************************************************************
Usage messages
*********************************************************************)

usage::MainBookLinkQ = "Failing notebooks contain buttons with the
obsolete \"MainBookLink\" or \"MainBookLinkMR\" styles.  Fix these
before shipping.";

usage::FontFamily = "The FontFamily option generally shouldn't be used
explicitly - that's what style sheets are for.  Two exceptions:
notebooks that document the option may use it for illustration; the
kernel may produce output that uses FontFamily.  If this option is
used legitimately in any of these notebooks, we can exclude them from
this test.";

usage::FontSize = "The FontSize option generally shouldn't be used
explicitly - that's what style sheets are for.  Two exceptions:
notebooks that document the option may use it for illustration; the
kernel may produce output that uses FontSize.  If this option is used
legitimately in any of these notebooks, we can exclude them from this
test.";

usage::InputDeemphasisQ = "Styled cells should be block cells, not
inline.";

(*********************************************************************
Begin private section of package
*********************************************************************)

Begin["`Private`"];

(* CVS Version *)
$CVSVersion = `$CVSVersion = "$Id: UnitTests.m,v 1.1 2008/05/07 17:38:29 andy Exp $";

(*********************************************************************
Code for unit tests
*********************************************************************)

(*********************************************************************
Here's a list of the tests that are currently applied to cvs
notebooks.  For starters, implement these as unit tests:

cvsTestList = {
  "FontFamily",
  "FontSize",
  "InputDeemphasis",
  "BrokenExampleLink",
  "MultipleExampleLinkCellTags",
  "NumberOfHistoryCells",
  "DotZeroHistoryNumber",
  "SubjectToChangeFlag",
  "DuplicateRelatedLinks",
  "DuplicateSeeAlsoLinks",
  "NoSeeAlso,"
  "EntityTypeQ",
  "MainBookLink",
  "UndocumentedIn",
  "BadUsageStyleBoxes",
  "NotebookCacheValidQ"
}
*********************************************************************)

(* .#1 FontFamilyQ *)

(**********************************************************************
walsh observed that FontFamily and FontSize specifications may
legitimately appear in kernel output, i.e. cells of style "Output".
Remove these cells before looking for instances of FontFamily.
**********************************************************************)

FontFamilyQ[nb_String] :=
  FontFamilyQ[Quiet@Get@nb];

FontFamilyQ[nbExpr_Notebook] := 
  Module[{expr},
    expr = DeleteCases[nbExpr, Cell[_, "Output", ___], Infinity];
    Cases[expr, _[FontFamily, f__], Infinity] === {}];

(* .#2 FontSizeQ *)

(**********************************************************************
walsh observed that FontFamily and FontSize specifications may
legitimately appear in kernel output, i.e. cells of style "Output".
Remove these cells before looking for instances of FontFamily and also
remove the popup menus - they have legitimate instances of FontSize.
**********************************************************************)

FontSizeQ[nb_String] := 
  FontSizeQ[Quiet@Get@nb];

FontSizeQ[nbExpr_Notebook] := 
  Module[{expr},
    expr = DeleteCases[nbExpr, Cell[_, "Output", ___], Infinity];
    expr = DeleteCases[expr, Cell[BoxData[PopupMenuBox[Dynamic[{"ActionMenu", None}, ___], ___]], ___], Infinity];
    Cases[expr, _[FontSize, __], Infinity] === {}]

(* .#3 InputDeemphasisQ *)

(**********************************************************************
"InputDeemphasis" styled cells should be block cells, not inline.
FlattenCellGroups lives in AuthorTools`Common.
**********************************************************************)

InputDeemphasisQ[nb_String] :=
  InputDeemphasisQ[Quiet@Get@nb];

InputDeemphasisQ[nbExpr_Notebook] := 
  Cases[FlattenCellGroups@nbExpr, Cell[_, "InputDeemphasis", ___], 2] === {};

(* .#4 BrokenExampleLinkQ *)

(*********************************************************************
Every ExampleLink ButtonData should have a corresponding CellTag or
CellID target in the notebook.  Here we compare the list of
ExampleLink ButtonData strings to the combined lists of CellTags and
CellIDs.

Please investigate the results of the following, with nbExpr =
Quiet@Get@nb.

Complement[
  Cases[
    nbExpr,
    ButtonBox[___, BaseStyle -> \"ExampleLink\", ___, ButtonData -> d_, ___] :> d,
    Infinity
  ],
  Flatten[
    {
      Cases[
        nbExpr,
        Cell[___, CellTags->t_, ___] :> t,
        Infinity
      ],
      Cases[
        nbExpr,
        Cell[___, CellID->id_, ___] :> id,
        Infinity
      ]
    }
  ]
]
*********************************************************************)

BrokenExampleLinkQ[nb_String] := 
  BrokenExampleLinkQ[Quiet@Get@nb];

BrokenExampleLinkQ[nbExpr_Notebook] := 
  Module[{data, tags},
    data = Cases[nbExpr, ButtonBox[___, BaseStyle -> "ExampleLink", ___, ButtonData -> d_, ___] :> d, Infinity];
    tags = Flatten@{ 
      Cases[nbExpr, Cell[___, CellTags->t_, ___] :> t, Infinity],
      Cases[nbExpr, Cell[___, CellID->id_, ___] :> id, Infinity]
    };
    Complement[data, tags] === {}];

(* .#5 MultipleExampleLinkCellTagsQ *)

(*********************************************************************
MultipleExampleLinkCellTagsQ: all CellTags of the form \"Ex-*\" should
be unique in a notebook.  Failing notebooks have duplicate Ex-
CellTags.
*********************************************************************)

(* 1. support functions *)

MultipleExampleLinkCellTags[nb_String] :=
  MultipleExampleLinkCellTags[Quiet@Get@nb];

MultipleExampleLinkCellTags[nbExpr_Notebook] :=
  Module[{tags},
    tags = DocumentationTools`Utilities`StringMatchCellTags[nbExpr, "Ex-*"];
    DocumentationTools`Utilities`DuplicateElements[tags]];

(* 2. main testing functions *)

MultipleExampleLinkCellTagsQ[nb_String] :=
  MultipleExampleLinkCellTagsQ[Quiet@Get@nb];

MultipleExampleLinkCellTagsQ[nbExpr_Notebook] := 
  DocumentationTools`Utilities`MultipleExampleLinkCellTags[nbExpr] === {};

(* .#6 NumberOfHistoryCellsQ *)

(*********************************************************************
Doc notebooks should have only 1 History cell.  Some of these may have
zero, others may have more than 1.
*********************************************************************)

NumberOfHistoryCellsQ[nb_String] :=
  NumberOfHistoryCellsQ[Quiet@Get@nb];

NumberOfHistoryCellsQ[nbExpr_Notebook] :=
  Count[nbExpr, Cell[___, "History", ___], Infinity] === 1;

(* .#7 DotZeroHistoryNumberQ *)

(*********************************************************************
Check for "New in: n.0" history tags: in well-formed History cells,
the "New in" number for n.0 releases should be simply n, not n.0.
*********************************************************************)

DotZeroHistoryNumberQ[nb_String] :=
  DotZeroHistoryNumberQ[Quiet@Get@nb];

DotZeroHistoryNumberQ[nbExpr_Notebook] :=
  Module[{history, data},
    history = Cases[nbExpr, Cell[s_, "History" | "HistoryData", ___] :> s, Infinity];
    If[Length@history > 0 && StringMatchQ[ToString[history], RegularExpression[".*[0-9]\\.0.*"]], 
      (* if a problem was found, return False *)
      False,
      True]]

(* .#8 NoNewInQ *)

(*********************************************************************
Every notebook that has a History cell, that cell must have the phrase
"New in <versionnumber>" (for in-product nbs) or "New in:
<versionnumber>" (for cvs nbs).
*********************************************************************)

NoNewInQ[nb_String] :=
  NoNewInQ[Quiet@Get@nb];

NoNewInQ[nbExpr_Notebook] :=
  Module[{history},
    NotebookStringsIgnoreCells = {};
    history = Cases[nbExpr, Cell[h_, "History", ___] :> h, Infinity];
    history = StringJoin[DocumentationTools`Utilities`NotebookStrings[history]];
    MatchQ[history, _String] && StringMatchQ[history, RegularExpression[".*New in:* [0-9].*"]]]

(* .#9 MainBookLinkQ *)

MainBookLinkQ[nb_String] :=
  MainBookLinkQ[Quiet@Get@nb];
	
MainBookLinkQ[nbExpr_Notebook] :=
  Count[
    nbExpr,
    ButtonBox[
      ___,
      Rule[
        BaseStyle|ButtonStyle|DefaultContentStyle,
        "MainBookLink"|"MainBookLinkMR"
      ],
      ___
    ],
    Infinity
  ] === 0

(* .#10 End private part of package *)

End[]

EndPackage[]

(* .#11 Local Variables *)

(**********************************************************************
Local Variables:
allout-layout: (-1 : )
End:
**********************************************************************)