(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14881,        400]
NotebookOptionsPosition[     13269,        345]
NotebookOutlinePosition[     13658,        362]
CellTagsIndexPosition[     13615,        359]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
  "applicationsDir", "=", 
   "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspaces\\webm\\\\DocumentationToolsHolder\\\\\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Path", ",", "applicationsDir"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.35690189997057*^9, 3.3569019006112*^9}, {
   3.36413094908612*^9, 3.36413095488311*^9}, {3.384607896397517*^9, 
   3.3846078994444313`*^9}, {3.3862783476994576`*^9, 3.3862783483244658`*^9}, 
   3.387635755589958*^9, 3.4016342811102495`*^9, {3.403208284019735*^9, 
   3.4032083123011656`*^9}, {3.403492293138484*^9, 3.4034923009821334`*^9}}],

Cell[BoxData[
 RowBox[{"<<", "DocumentationTools`"}]], "Input",
 CellChangeTimes->{{3.35690189997057*^9, 3.3569019006112*^9}, {
   3.36413094908612*^9, 3.36413095488311*^9}, {3.384607896397517*^9, 
   3.3846078994444313`*^9}, {3.3862783476994576`*^9, 3.3862783483244658`*^9}, 
   3.387635755589958*^9, 3.4016342811102495`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "guidesDir", "=", 
   "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspaces\\\\webm\\\\webMathematicaHolder\\\\\
webMathematica\\\\Documentation\\\\English\\\\Guides\\\\\>\""}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.401634321329514*^9, 3.4016343245951805`*^9}, {
  3.403208327801265*^9, 3.4032083314575386`*^9}, {3.403492894677659*^9, 
  3.4034929228335485`*^9}, {3.4034930115824127`*^9, 3.4034930215197854`*^9}, {
  3.403493102175003*^9, 3.4034931072843122`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DocumentationTools`Navigation`$Pages", "=", 
  RowBox[{
  "DocumentationTools`Navigation`ComputeLinkTrails", "[", "guidesDir", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.4013948678558483`*^9, 3.401394874559059*^9}, {
   3.4016343160325713`*^9, 3.401634319048235*^9}, 3.403492926567876*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringJoin", "::", "\<\"string\"\>"}], ":", 
  " ", "\<\"String expected at position \\!\\(1\\) in \\!\\(\\(\\(Cell[\\(\\(\
\\(\\(BoxData[\\(\\(StyleBox[\\(\\(RowBox[\\(\\({\\\"web\\\", \
\\(\\(AdjustmentBox[\\(\\(\\\"Mathematica\\\", \\(\\(Rule[\\(\\(\
\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\)\\)\\)]\\)\\)}\\)\\)]\\)\\)]\\)\\)]\\)\\), \
\\\"InlineMath\\\"\\)\\)]\\)\\) <> \\\" Tags\\\"\\).\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.403492940380199*^9, 3.403493034285247*^9, 
  3.4034931363464403`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringJoin", "::", "\<\"string\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"String expected at position \\!\\(1\\) in \
\\!\\(\\(\\(Cell[\\(\\(\\(\\(BoxData[\\(\\(StyleBox[\\(\\(RowBox[\\(\\({\\\"\
web\\\", \\(\\(AdjustmentBox[\\(\\(\\\"Mathematica\\\", \\(\\(Rule[\\(\\(\
\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\)\\)\\)]\\)\\)}\\)\\)]\\)\\)]\\)\\)]\\)\\), \
\\\"InlineMath\\\"\\)\\)]\\)\\) <> \\\" Tags\\\"\\).\"\>"}]], "Message", \
"MSG",
 CellChangeTimes->{3.403492940380199*^9, 3.403493034285247*^9, 
  3.4034931451900773`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"StringJoin", "::", "\<\"string\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"String expected at position \\!\\(1\\) in \
\\!\\(StringJoin[\\(\\(Cell[\\(\\(\\(\\(BoxData[\\(\\(StyleBox[\\(\\(RowBox[\\\
(\\({\\\"web\\\", \\(\\(AdjustmentBox[\\(\\(\\\"Mathematica\\\", \
\\(\\(Rule[\\(\\(\[LeftSkeleton] 2 \
\[RightSkeleton]\\)\\)]\\)\\)\\)\\)]\\)\\)}\\)\\)]\\)\\)]\\)\\)]\\)\\), \
\\\"InlineMath\\\"\\)\\)]\\)\\)]\\).\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.403492940380199*^9, 3.403493034285247*^9, 
  3.4034931495806465`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"stop\"\>"}], 
  RowBox[{
  ":", " "}], "\<\"Further output of \\!\\(StringJoin :: \\\"string\\\"\\) \
will be suppressed during this calculation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/stop\\\", ButtonNote -> \
\\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.403492940380199*^9, 3.403493034285247*^9, 
  3.4034931528306046`*^9}],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellChangeTimes->{3.40349294302079*^9, 3.4034931160029507`*^9, 
  3.4034931528306046`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "file", "=", 
   "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspaces\\\\webm\\\\webMathematicaHolder\\\\\
webMathematica\\\\Documentation\\\\English\\\\Tutorials\\\\\
TroubleShootingReporting.nb\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.4034931791740174`*^9, 3.403493198298773*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "file", "=", 
   "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspaces\\\\webm\\\\webMathematicaHolder\\\\\
webMathematica\\\\Documentation\\\\English\\\\ReferencePages\\\\Config\\\\\
Checktoexpression.nb\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.4034931791740174`*^9, 3.403493198298773*^9}, {
  3.4034941048652935`*^9, 3.403494133646175*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "file", "=", 
   "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspaces\\\\webm\\\\webMathematicaHolder\\\\\
webMathematica\\\\Documentation\\\\English\\\\ReferencePages\\\\Symbols\\\\\
MSPValue.nb\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.4034931791740174`*^9, 3.403493198298773*^9}, {
   3.4034941048652935`*^9, 3.403494133646175*^9}, {3.4034947173574533`*^9, 
   3.4034947234355006`*^9}, {3.4034954030908494`*^9, 3.4034954051228013`*^9}, 
   3.403495503109779*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "file", "=", 
   "\"\<C:\\\\Documents and \
Settings\\\\andy\\\\workspaces\\\\webm\\\\webMathematicaHolder\\\\\
webMathematica\\\\Documentation\\\\English\\\\Tutorials\\\\\
AdvancedTopicsMappingURLs.nb\>\""}], ";"}]], "Input",
 CellChangeTimes->{{3.4034931791740174`*^9, 3.403493198298773*^9}, {
   3.4034941048652935`*^9, 3.403494133646175*^9}, {3.4034947173574533`*^9, 
   3.4034947234355006`*^9}, {3.4034954030908494`*^9, 3.4034954051228013`*^9}, 
   3.403495503109779*^9, {3.4034996441803484`*^9, 3.4034996477118473`*^9}, {
   3.4034996806360397`*^9, 3.403499690167961*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"nbObj", "=", 
   RowBox[{"NotebookPut", "@", 
    RowBox[{"MakeOnlineNotebook", "[", "file", "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.3846079477888002`*^9, 3.3846079603202105`*^9}, {
  3.384608091462514*^9, 3.3846081046501827`*^9}, {3.3846133880169396`*^9, 
  3.3846133905858355`*^9}, {3.3889174722527876`*^9, 3.3889174770184736`*^9}, {
  3.401745678187993*^9, 3.4017456787036247`*^9}, {3.4032243336068263`*^9, 
  3.4032243342943306`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportWebPage", "[", 
  RowBox[{
   RowBox[{"\"\<E:\\\\documentation.w.c\\\\tmp\\\\\>\"", "<>", 
    RowBox[{"StringReplace", "[", 
     RowBox[{"file", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"DirectoryName", "[", "file", "]"}], "\[Rule]", "\"\<\>\""}],
         ",", 
        RowBox[{"\"\<.nb\>\"", "\[Rule]", "\"\<\>\""}]}], "}"}]}], "]"}], 
    "<>", "\"\<.html\>\""}], ",", "file", ",", 
   RowBox[{"NotebookPageType", "@", 
    RowBox[{"NotebookEntityType", "@", "file"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.3796941689031467`*^9, 3.3796941774501314`*^9}, {
   3.379694402593638*^9, 3.3796944043592854`*^9}, {3.3835777286631165`*^9, 
   3.383577729835006*^9}, {3.3846279199306774`*^9, 3.3846279222413273`*^9}, {
   3.3846366098966684`*^9, 3.3846366102567015`*^9}, {3.3864098725944214`*^9, 
   3.3864098741254654`*^9}, {3.3864334696963377`*^9, 3.386433471524486*^9}, 
   3.3864371268725185`*^9, 3.386635837772066*^9, 3.386710093362075*^9, {
   3.3867612348329153`*^9, 3.386761238286085*^9}, {3.386812786800637*^9, 
   3.3868127877068987`*^9}, {3.387073059762717*^9, 3.3870730625440025`*^9}, {
   3.387685121690586*^9, 3.3876851253156323`*^9}, 3.3876860854060464`*^9, {
   3.399656702244137*^9, 3.3996567030722723`*^9}, {3.3998301843359027`*^9, 
   3.3998302363365684`*^9}}],

Cell[BoxData["\<\"E:\\\\documentation.w.c\\\\tmp\\\\MSPValue.en.html\"\>"], \
"Output",
 CellChangeTimes->{3.403498038520443*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["other stuff", "Section",
 CellChangeTimes->{{3.4034928603812227`*^9, 3.403492862709318*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "appPath", "=", 
   "\"\</Users/andy/workspaces/default/DocumentationToolsDEVEL/\>\""}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   StyleBox["PrependTo",
    GridBoxOptions->{
    GridBoxAlignment->{
     "Columns" -> {Left, {Right}}, "ColumnsIndexed" -> {}, "Rows" -> {{Top}}, 
      "RowsIndexed" -> {}}}], "[", 
   RowBox[{"$Path", ",", "appPath"}], "]"}], ";"}]}], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.36337006827931*^9, 3.36337006891941*^9}, 
   3.3750161235532217`*^9, 3.375117424530504*^9, {3.384536820838772*^9, 
   3.384536823833435*^9}, {3.398400909627674*^9, 3.398400913042562*^9}, {
   3.39862353682831*^9, 3.398623537496533*^9}, {3.398623606212783*^9, 
   3.398623609305867*^9}, {3.398623933409539*^9, 3.3986239733982573`*^9}, {
   3.398624058935392*^9, 3.398624061069291*^9}, {3.400867620747892*^9, 
   3.400867624617577*^9}, 3.4008829949287767`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"<<", "DocumentationTools`"}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.36337006827931*^9, 3.36337006891941*^9}, 
   3.3750161235532217`*^9, 3.375117424530504*^9, {3.384536820838772*^9, 
   3.384536823833435*^9}, {3.398400909627674*^9, 3.398400913042562*^9}, {
   3.39862353682831*^9, 3.398623537496533*^9}, {3.398623606212783*^9, 
   3.398623609305867*^9}, {3.398623933409539*^9, 3.3986239733982573`*^9}, {
   3.398624058935392*^9, 3.398624061069291*^9}, {3.400867620747892*^9, 
   3.400867624617577*^9}, 3.4008829949287767`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"docsDir", ",", "outputDir"}], "}"}], "=", "\[IndentingNewLine]", 
   
   RowBox[{"Switch", "[", 
    RowBox[{
    "$OperatingSystem", ",", "\[IndentingNewLine]", "\"\<MacOSX\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\</Users/andy/workspaces/default/MathematicaDocumentation/\
Documentation/English/System/\>\"", ",", "\"\</tmp/web/\>\""}], "}"}], ",", 
     "\[IndentingNewLine]", "\"\<Unix\>\"", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\</dept/Pubs/OnlineProduction/andy/workspaces/default/\
MathematicaDocumentationDEVEL/Source/Documentation/English/System/\>\"", ",", 
       "\"\</tmp/web/\>\""}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.400227895047288*^9, 3.4002279005789623`*^9}, {
   3.4002279310176687`*^9, 3.4002279374631243`*^9}, {3.400228058713318*^9, 
   3.4002280964645863`*^9}, {3.4002282562141857`*^9, 3.400228269956415*^9}, {
   3.4002283941273623`*^9, 3.4002283969277773`*^9}, {3.400228772724415*^9, 
   3.400228817385756*^9}, 3.40023813855837*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"guidesDir", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"{", 
     RowBox[{"docsDir", ",", "\"\<Guides\>\""}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.400229319367325*^9, 3.4002293272781973`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"files", "=", 
   RowBox[{"FileNames", "[", 
    RowBox[{"\"\<*.nb\>\"", ",", "guidesDir"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.400229553030249*^9, 3.4002295568353653`*^9}, {
  3.400229890147582*^9, 3.400229901915107*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "@", "files"}]], "Input",
 CellChangeTimes->{{3.400241041295537*^9, 3.400241072707116*^9}}],

Cell[BoxData["375"], "Output",
 CellChangeTimes->{{3.4002410487820587`*^9, 3.400241073300611*^9}, 
   3.4002413314298277`*^9, 3.400867575889*^9, 3.400882373875259*^9, 
   3.4008998058063517`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"primaryGuideList", "=", 
   RowBox[{"MakePrimaryGuideList", "@", "guidesDir"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4008675805121737`*^9, 3.400867586443513*^9}},
 EmphasizeSyntaxErrors->True],

Cell[BoxData["primaryGuideList"], "Input",
 CellChangeTimes->{{3.4008998360773773`*^9, 3.400899865078018*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", "\"\<paclet:ref/Sin\>\"", ")"}], "/.", 
  "primaryGuideList"}]], "Input",
 CellChangeTimes->{{3.400867651557561*^9, 3.40086768287749*^9}, {
  3.400867922768467*^9, 3.4008679258954983`*^9}}],

Cell[BoxData["\<\"TrigonometricFunctions\"\>"], "Output",
 CellChangeTimes->{{3.4008676742441797`*^9, 3.400867683790653*^9}, 
   3.400867926924346*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"DocumentationTools`Navigation`$Pages", "=", 
   RowBox[{
   "DocumentationTools`Navigation`ComputeLinkTrails", "[", "guidesDir", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.4002292997536182`*^9, 3.400229334551424*^9}}]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{821, 715},
WindowMargins->{{35, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (June 14, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 658, 14, 52, "Input"],
Cell[1229, 37, 326, 5, 31, "Input"],
Cell[1558, 44, 509, 11, 92, "Input"],
Cell[CellGroupData[{
Cell[2092, 59, 315, 6, 31, "Input"],
Cell[2410, 67, 555, 11, 39, "Message"],
Cell[2968, 80, 568, 12, 39, "Message"],
Cell[3539, 94, 561, 11, 39, "Message"],
Cell[4103, 107, 509, 10, 21, "Message"],
Cell[4615, 119, 137, 3, 30, "Output"]
}, Open  ]],
Cell[4767, 125, 330, 8, 92, "Input"],
Cell[5100, 135, 389, 9, 92, "Input"],
Cell[5492, 146, 512, 11, 92, "Input"],
Cell[6007, 159, 615, 12, 92, "Input"],
Cell[6625, 173, 483, 9, 31, "Input"],
Cell[CellGroupData[{
Cell[7133, 186, 1345, 25, 72, "Input"],
Cell[8481, 213, 129, 2, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8647, 220, 98, 1, 71, "Section"],
Cell[8748, 223, 921, 21, 52, "Input",
 InitializationCell->True],
Cell[9672, 246, 589, 10, 31, "Input",
 InitializationCell->True],
Cell[10264, 258, 1070, 23, 172, "Input"],
Cell[11337, 283, 254, 7, 31, "Input"],
Cell[11594, 292, 269, 6, 31, "Input"],
Cell[CellGroupData[{
Cell[11888, 302, 124, 2, 31, "Input"],
Cell[12015, 306, 195, 3, 30, "Output"]
}, Open  ]],
Cell[12225, 312, 231, 5, 31, "Input"],
Cell[12459, 319, 110, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[12594, 324, 228, 5, 31, "Input"],
Cell[12825, 331, 151, 2, 30, "Output"]
}, Open  ]],
Cell[12991, 336, 262, 6, 31, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
