(* ::Package:: *)

(* Mathematica Package *)

(* Created by the Wolfram Workbench Jun 15, 2007 *)

BeginPackage["DocumentationBuild`Navigation`"]
(* Exported symbols added here with SymbolName::usage *) 

General::blah = "blah"

GuideNotebookList::usage = "GuideNotebookList[dir] returns list of guides within dir.";
OverviewNotebookList::usage = "OverviewNotebookList[dir] returns a list of overviews within dir.";
PackageGuideNotebookList::usage = "PackageGuideNotebookList[dir] returns all guides under dir.";
LinkTrailListFromFilename::usage = "LinkTrailListFromFilename[filename] returns list of computed link trails.";
GetPrimaryGuideForFunctionList::usage = "";

Children
Parents
Genesis

FindName
FindNumber

$NameToNumberRules
$NumberToNameRules
$Graph
$Pages = {};
ComputeLinkTrails
MakeLinkTrails
AddLinkTrails

FunctionLinkQ
GetFunctionName

(* *)
PageLinks
(*files*)
LinkToGuideQ

ComputeTutorialLinkTrails
$TutNameToNumberRules
$TutNumberToNameRules
$TutGraph
$TutPages = {};
TutParents
TutChildren

ComputePackageGuideLinkTrails
$PkgNameToNumberRules
$PkgNumberToNameRules
$PkgGraph
$PkgPages = {};
PkgParents
PkgChildren

(* Forward/Back navigation *)

GetBackUpForwardFromParent;
GetForwardBack;
GetNavDestinations;

(* Other *)

GetTutorialAnchors;
GetExamplePageData;
GetExamplePageThumbnail;
GetFeaturedExampleLinksToGuide;

GetListOfHowToLandingPagesAndSubpages;

Begin["`Private`"]


CurrentFileQ[f_String] := 
   With[{nbdata = Quiet[Get[f]]}, 
 	  (FreeQ[{DocumentationBuild`Utils`DocumentFlag[nbdata]}, "FutureFlag"] || 
         MemberQ[nbdata, Cell[___, CellTags -> "UnderDevelopment", ___], Infinity]) 
      && 
       FreeQ[{DocumentationBuild`Utils`DocumentFlag[nbdata]}, "ExcisedFlag" | "InternalFlag"]
   ]

CleanupName[s_] :=
  Module[{str=s},
    str = If[ StringQ[str],
        StringReplace[
           str, {" \[RightGuillemet]" -> "", "\[RightGuillemet]" -> "", " \[FilledRightTriangle]" -> "", 
            "\[FilledRightTriangle]" -> "", "paclet:guide/" -> "", "paclet:tutorial/" -> ""}],
        ""
    ];
    str = If[!StringFreeQ[str, $PathnameSeparator~~"Guides"~~$PathnameSeparator],
    	StringReplace[StringJoin[Prepend[Riffle[StringReplace[#, first__~~"J"~~EndOfString:>first]&/@Take[StringSplit[str,$PathnameSeparator], If[StringFreeQ[str, $PathnameSeparator~~"System"~~$PathnameSeparator],-3,-2];;-1], "/"], "paclet:"]], "Guides"->"guide"],
    	str];
    str
  ];

CleanupItalics[s_] :=
    s /. {
       StyleBox[q_, FontSlant -> "Italic"] :> q,
       AdjustmentBox[q_, ___] :> q
       } /. {TextData[x___] :> StringJoin[x]}

JoinStringPieces[
  l_List] :=
    {StringJoin[Transpose[#][[1]]], #[[1, 2]]} & /@ 
     Split[l, #1[[2]] == #2[[2]] &]


ProcessButtonBox[title_,opts___] :=
    {}

FunctionLinkQ[ButtonBox[name_,opts___]] := 
	MatchQ[BaseStyle /. FilterRules[{opts}, BaseStyle], "Link"|{"Link"}] && 
	( FreeQ[{opts}, ButtonData] || With[{target = ButtonData /. FilterRules[{opts}, ButtonData]}, 
		StringMatchQ[target, RegularExpression["paclet:ref/[^/]*"]]])


GetFunctionName[ButtonBox[name_,opts___]] := 
	Which[
		FreeQ[{opts},ButtonData], name,
		True, With[{target = ButtonData /. FilterRules[{opts}, ButtonData]}, 
		StringCases[target, RegularExpression["paclet:ref/([^/]*)"]:>First["$1"]]]
	]


(* RootLinks[includeall_:False] :=
    DeleteCases[
      Module[ {x, s, data, title, newtitle, nb, from, to, ll, s1},
          With[ {
            nbdata = Quiet[Get[#]],
            name = StringReplace[#, ".nb" -> ""]
            },
              If[ ! MemberQ[nbdata, "FutureFlag" | "ExcisedFlag", Infinity],
                  title = 
                   CleanupItalics[
                    Cases[nbdata, 
                     Cell[t_, "GuideTitle" | "GuideTOCTitle", ___] :> t, 
                     Infinity]];
                  data = 
                   DeleteCases[nbdata, 
                    Cell[___, 
                     "GuideTutorial" | "GuideRelatedLinks" | 
                     "FutureExample" | "SpecialConversion", ___], Infinity];
                  If[ !TrueQ[includeall],
                      data = 
                             DeleteCases[data, 
                            Cell[___, "GuideMoreAbout" | "GuideMoreAboutSub" , ___], Infinity];
                  ];
                  If[ !TrueQ[includeall],
                      data = 
                          DeleteCases[data, 
                            Cell[___, "TOCExcludedObject" , ___], Infinity];
                      data = 
                          DeleteCases[data, 
                            ButtonBox[y___] /; MemberQ[{y}, "TOCExcludedObject", Infinity], 
                               Infinity];
                  ];
                  data = 
                      DeleteCases[data, 
                        ButtonBox[_, opts___] /; MatchQ[BaseStyle /. FilterRules[{opts}, BaseStyle],
                            "Hyperlink" | "GenericLink"], 
                           Infinity];
                  data = 
                   Cases[data, 
                    Cell[section_, 
                      "GuideFunctionsSubsection" | "TOCChapter" | 
                       "GuideFunctionsSection" | "GuideText" | "GuideMoreAbout" | 
                       "GuideMoreAboutSub", ___] :> section, 
                    Infinity];
                  data = 
                   Cases[data, 
                     ButtonBox[name_, opts___] :> 
                      CleanupName[ButtonData /. FilterRules[{opts}, ButtonData]],
                      Infinity] /. {TextData[x_] :> StringJoin[x]};
                  {name, Union[data]}
              ]
          ]
      ] & /@ {"Mathematica.nb"}, Null];
*)

PageLinks[file_,include_:None, "Guides"] :=
         Module[ {x, s, data, title, filename, newtitle, nb, from, to, ll, s1},
             data = Quiet[Get[file]];
             filename = CleanupName[StringReplace[file, ".nb" -> ""]];
             title = CleanupItalics[
                   Cases[data, 
                     Cell[t_, "GuideTitle" | "GuideTOCTitle", ___] :> t, 
                     Infinity]];
             data = DeleteCases[data, 
                       Cell[___, 
                        If[StringMatchQ[filename, (* XX Root guide rename change XX *)(*"Mathematica"|*)"WolframRoot"], "GuideTutorial" | "GuideRelatedLinks" | 
                        "FutureExample" | "ConversionSpecial", "GuideTutorial" | "GuideRelatedLinks" | 
                        "FutureExample" | "ConversionSpecial" | "GuideText"], ___], Infinity];
             If[ !TrueQ[include===All],
                 data = DeleteCases[data, 
                           Cell[___, "GuideMoreAbout" | "GuideMoreAboutSub" , ___], Infinity];
             ];
             If[ !TrueQ[include===All],
                 data = DeleteCases[data, 
                            Cell[___, "TOCExcludedObject" , ___], Infinity];
                 data = DeleteCases[data, 
                            ButtonBox[y___]/;MemberQ[{y}, "TOCExcludedObject", Infinity], 
                               Infinity];
             ];
             data = DeleteCases[data, 
                        ButtonBox[_, opts___] /; MatchQ[BaseStyle /. FilterRules[{opts}, BaseStyle],
                            "Hyperlink" | "GenericLink"], 
                           Infinity];
             data = Cases[data, 
                       Cell[section_, 
                         "GuideFunctionsSection" | "GuideFunctionsSubsection" | "TOCChapter" | "GuideText" | 
                          "GuideTOCLink" | "GuideMoreAbout" | "GuideMoreAboutSub", ___] :> section, Infinity];
             data = DeleteCases[data,
             			ButtonBox[name_, opts___] /; Not[LinkToGuideQ[opts]],Infinity];
             data = Cases[data, 
                        ButtonBox[name_, opts___] /; MemberQ[{opts}, ButtonData, Infinity] :> 
                         CleanupName[ButtonData /. FilterRules[{opts}, ButtonData]], 
                        Infinity] /. {TextData[x_] :> StringJoin[x]};
             {filename, Union[data]}
         ]

PageLinks[file_, include_: None, "Tutorials"] :=
 Module[{nbdata = Quiet[Get[file]], filename, links, c},
  filename = StringReplace[file, ".nb" -> ""];
  links = 
   DeleteCases[
    Cases[nbdata, 
     Cell[stuff___, "TOCChapter"|"TOCSection"|"TOCSubsection", ___] :> 
      If[Length[(c = 
           Cases[stuff, 
            ButtonBox[str_, ___, ButtonData -> uri_String, ___] /; 
              StringMatchQ[uri, "paclet:tutorial/*"] :> 
             StringReplace[CleanupName[uri],("#"~~DigitCharacter..)->""], Infinity])] <= 1, c, 
       Union[c]], Infinity], {}, Infinity];
  {filename, Union[Flatten[links]]}]

LinkToGuideQ[x___] :=
    MemberQ[{x}, ButtonData, Infinity] && 
     StringMatchQ[ButtonData /. FilterRules[{x}, ButtonData], 
      "paclet:*guide/" ~~ ___]
   

FindName[n_Integer] :=
    n /. $NumberToNameRules

FindNumber[s_String] :=
    s /. $NameToNumberRules

JoinPairs[l_List] :=
    With[ {t = Transpose[l]},
        {t[[1, 1]], t[[2]]}
    ]

LinkBox[x_] :=
    With[ {name = x /. $NumberToNameRules},
        ButtonBox[name, BaseStyle -> "Link", 
         ButtonData -> "paclet:guide/" <> name]
    ]

GuideEntry[s_] :=
    {Cell[First[s] /. $NumberToNameRules, "Subsection", 
   CellDingbat -> None, ShowGroupOpener -> True], 
      Sequence @@ 
       Function[x, 
     Cell[BoxData[
       RowBox[Riffle[LinkBox /@ x, " \[FilledRightTriangle] "]]], 
      "Text"]] /@ s[[2]]}


Children[n_Integer] :=
    Cases[$Graph, HoldPattern[Rule[n, x_]] :> x]

TutChildren[n_Integer] :=
    Cases[$TutGraph, HoldPattern[Rule[n, x_]] :> x]
    
PkgChildren[n_Integer, root_String] :=
    Cases[$PkgGraph[root], HoldPattern[Rule[n, x_]] :> x]

Children[n_String] :=
    Children[n /. $NumberToNameRules] /. $NameToNumberRules

TutChildren[n_String] :=
    TutChildren[n /. $TutNumberToNameRules] /. $TutNameToNumberRules
    
PkgChildren[n_String, root_String] :=
    PkgChildren[n /. $PkgNumberToNameRules[root], root] /. $PkgNameToNumberRules[root]

Parents[n_Integer] :=
    Cases[$Graph, HoldPattern[Rule[x_, n]] :> x]

TutParents[n_Integer] :=
    Cases[$TutGraph, HoldPattern[Rule[x_, n]] :> x]
    
PkgParents[n_Integer, root_String] :=
    Cases[$PkgGraph[root], HoldPattern[Rule[x_, n]] :> x]

Parents[n_String] :=
    Parents[n /. $NumberToNameRules] /. $NameToNumberRules

TutParents[n_String] :=
    TutParents[n /. $TutNumberToNameRules] /. $TutNameToNumberRules
    
PkgParents[n_String, root_String] :=
    PkgParents[n /. $PkgNumberToNameRules[root], root] /. $PkgNameToNumberRules[root]

Genesis[n_] :=
    {n, "Parents" -> Parents[n], "Children" -> Children[n]}

NumberLink[n_] :=
    link[$GUIDES, n /. $NumberToNameRules, ".nb"]

NumberURI[n_] :=
    Hyperlink[n /. $NumberToNameRules, "paclet:guide/" <> (n /. $NumberToNameRules)]


(* GUIDE LINK TRAILS *)

(* ComputeLinkTrails from a given directory or current directory *)
ComputeLinkTrails[dir_String:Directory[], includeall_:None] :=
	ComputeLinkTrails[ GuideNotebookList[dir], includeall];

(* ComputeLinkTrails from a list of Guides *)
ComputeLinkTrails[files_List, includeall_:None] :=
    Module[ {root,links,all,xroot,x,L,L1,newin6num},
        root = {PageLinks[(* XX Root guide rename change XX *)(*"Mathematica.nb"*)"WolframRoot.nb",includeall, "Guides"]};
        links = PageLinks[#,includeall, "Guides"]&/@ files;
        all = Join[links, root];
        $NameToNumberRules = With[ {guidenames = Union[Flatten[all]]},
                                 Thread[Rule[guidenames, Range[Length[guidenames]]]]
                             ];
     (* Fixed $NumberToNameRules = Reverse[$NameToNumberRules, 2]; *)
        $NumberToNameRules = Reverse /@ $NameToNumberRules;
        newin6num = newin6GuideList[files] /. $NameToNumberRules;
        $Graph = Flatten[Thread[Rule @@ #] & /@ all] /. $NameToNumberRules;
        $Graph = DeleteCases[$Graph, HoldPattern[
            Rule[x_ /; MemberQ[newin6num, x], y_ /; FreeQ[newin6num, y]]]];
        xroot = (* XX Root guide rename change XX *)(*"Mathematica"*)"WolframRoot" /. $NameToNumberRules;
        x = {#, {xroot}} & /@ Children[xroot];
        L = 0;
        L1 = -1;
        While[L != L1,
            L = Length[Union[First /@ x]];
            x = Union[x, Union[Flatten[Function[t, 
                With[ {ch = Children[t[[1]]]},
                    If[ Length[ch] > 0,
                        Function[y, If[ FreeQ[t[[2]], y],
                                        {y, Append[t[[2]], t[[1]]]},
                                        t
                                    ]] /@ ch,
                        {t}
                    ]
                ]] /@ x, 1]]];
            L1 = Length[Union[First /@ x]]
        ];
        JoinPairs /@ Split[x, #1[[1]] == #2[[1]] &]
    ]


(* TUTORIAL LINK TRAILS *)

ComputeTutorialLinkTrails[dir_String:Directory[], includeall_:None] :=
	ComputeTutorialLinkTrails[ OverviewNotebookList[dir], includeall];

ComputeTutorialLinkTrails[files_List, includeall_:None] :=
    Module[ {root,links,all,xroot,x,L,L1},
        root = {PageLinks["VirtualBookOverview.nb",includeall, "Tutorials"]};
        links = PageLinks[#,includeall, "Tutorials"]&/@ files;
        all = Join[links, root];
        $TutNameToNumberRules = With[ {guidenames = Union[Flatten[all]]},
                                 Thread[Rule[guidenames, Range[Length[guidenames]]]]
                             ];
        $TutNumberToNameRules = Reverse /@ $TutNameToNumberRules;
        $TutGraph = Flatten[Thread[Rule @@ #] & /@ all] /. $TutNameToNumberRules;
        xroot = "VirtualBookOverview" /. $TutNameToNumberRules;
        x = {#, {xroot}} & /@ TutChildren[xroot];
        L = 0;
        L1 = -1;
        While[L != L1,
            L = Length[Union[First /@ x]];
            x = Union[x, Union[Flatten[Function[t, 
                With[ {ch = TutChildren[t[[1]]]},
                    If[ Length[ch] > 0,
                        Function[y, If[ FreeQ[t[[2]], y],
                                        {y, Append[t[[2]], t[[1]]]},
                                        t
                                    ]] /@ ch,
                        {t}
                    ]
                ]] /@ x, 1]]];
            L1 = Length[Union[First /@ x]]
        ];
        JoinPairs /@ Split[x, #1[[1]] == #2[[1]] &]
    ];
    
(* PACKAGE GUIDE LINK TRAILS *)

ComputePackageGuideLinkTrails[dirs_List /; And@@(DirectoryQ /@ dirs), rootguidedir_String, rootguidenb_String, includeall_:None] :=
    ComputePackageGuideLinkTrails[Flatten[PackageGuideNotebookList/@dirs], rootguidedir, rootguidenb, includeall];

ComputePackageGuideLinkTrails[dir_String:Directory[], rootguidedir_String, rootguidenb_String, includeall_:None] :=
	ComputePackageGuideLinkTrails[ PackageGuideNotebookList[dir], rootguidedir, rootguidenb, includeall];

ComputePackageGuideLinkTrails[files_List /; Union[FileType /@ files] === {File}, rootguidedir_String, rootguidenb_String, includeall_:None] :=
    Module[ {rooturi, root,links,all,xroot,x,L,L1, SEPnbpath = First@FileNames[rootguidenb, rootguidedir], rootguide = StringReplace[rootguidenb, ".nb"->""], rootnbdata = Get[FileNameJoin[{rootguidedir, rootguidenb}]]},
        rooturi = Cases[rootnbdata, 
        	Cell[___, "Categorization", ___, CellLabel -> "URI", ___], Infinity][[1, 1]];
        root = {PageLinks[SEPnbpath,includeall, "Guides"]};
        links = PageLinks[#,includeall, "Guides"]&/@ files;
        all = Join[links, root];
        $PkgNameToNumberRules[rootguide] = With[ {guidenames = Union[Flatten[all]]},
                                 Thread[Rule[guidenames, Range[Length[guidenames]]]]
                             ];
        $PkgNumberToNameRules[rootguide] = Reverse /@ $PkgNameToNumberRules[rootguide];
        $PkgGraph[rootguide] = Flatten[Thread[Rule @@ #] & /@ all] /. $PkgNameToNumberRules[rootguide];
        xroot = ("paclet:"<>rooturi) /. $PkgNameToNumberRules[rootguide];
        x = {#, {xroot}} & /@ PkgChildren[xroot, rootguide];
        L = 0;
        L1 = -1;
        While[L != L1,
            L = Length[Union[First /@ x]];
            x = Union[x, Union[Flatten[Function[t, 
                With[ {ch = PkgChildren[t[[1]], rootguide]},
                    If[ Length[ch] > 0,
                        Function[y, If[ FreeQ[t[[2]], y],
                                        {y, Append[t[[2]], t[[1]]]},
                                        t
                                    ]] /@ ch,
                        {t}
                    ]
                ]] /@ x, 1]]];
            L1 = Length[Union[First /@ x]]
        ];
        JoinPairs /@ Split[x, #1[[1]] == #2[[1]] &]
    ];
    
    

MakeLinkTrails[$Pages_List] :=
    CreateDocument[Notebook[Sequence @@ GuideEntry[#] & /@ $Pages]];

AddLinkTrails[s_List] :=
    {};


GuideNotebookList[dir_String]:= 
Module[{curDir, guides, files},
	curDir = Directory[];
	SetDirectory[dir];
	guides = FileNames["*.nb"];
	files = 
		Complement[
    		Select[ guides, CurrentFileQ], 
    		{"AlphabeticalListing.nb", 
   			"AlphabeticalListingOfMathLinkCFunctions.nb"},
   			Select[guides, StringMatchQ[#, "NewIn*"]&],
   			Select[guides, StringMatchQ[#, "SummaryOfNewFeaturesIn*.nb"]&]
    	];
	(*SetDirectory[curDir];*)
	files
]; 
   
OverviewNotebookList[dir_String] :=
 Module[{curDir, overviews, files}, curDir = Directory[];
  SetDirectory[dir];
  overviews = FileNames["*Overview.nb"];
  files = Select[overviews, CurrentFileQ];
  (*SetDirectory[curDir];*)
  files];
  
PackageGuideNotebookList[dir_String]:= 
Module[{curDir, guides, files},
	curDir = Directory[];
	SetDirectory[dir];
	guides = FileNames["*.nb", dir, Infinity];
	files = Select[ guides, (CurrentFileQ[#] && !StringFreeQ[#, $PathnameSeparator ~~ "Guides" ~~ $PathnameSeparator])&];
	(*SetDirectory[curDir];*)
	files
];
    
newin6GuideList[files_List]:= 
	StringReplace[Select[files, StringMatchQ[#, ___ ~~ "NewIn" ~~ ___] &], ".nb" -> ""];

(*commenting until tutorial link trails are ready*)
(*tuttrailinit[]:=Module[{nb=Get["C:\\Workspace\\Tutorials\\VirtualBookContents.nb"],cnew},
  cnew=ReplaceRepeated[
    ReplaceRepeated[
      DeleteCases[
        ReplaceRepeated[
          DeleteCases[
          ReplaceRepeated[nb,{Cell[CellGroupData[x_,___]]:>x}],Cell[x___/;FreeQ[{x},
			Alternatives@@{"TOCDocumentTitle","TOCPart","TOCChapter","TOCSection","TOCSubsection","TOCSubsubsection","TOCSubsubsubsection"}]]|
			Cell[___,"TentativeExample",___],Infinity],Cell[x___,sty_String/;StringMatchQ[sty,Alternatives@@{"TOCDocumentTitle","TOCPart","TOCChapter","TOCSection","TOCSubsection","TOCSubsubsection","TOCSubsubsubsection"}],___]:>Cell[x,sty]],{},Infinity][[1,1]],StyleBox[x_,OptionsPattern[]]:>x],TextData[x___/;FreeQ[x,ButtonBox]]:>StringJoin[x]];
  cnew2=ReplaceAll[cnew,{Cell[bb:Except[_String],sty_String]:>Cell[{ConvertToString[bb],Union[ButtonData/.(Rest/@(List@@@Cases[bb,ButtonBox[___],Infinity]))]},sty],Cell[s1_String,s2_String]:>Cell[{s1,{}},s2]}];
True
];

FindLinkTrail[URI_String]:=
  Module[{uri=URI},
   (If[!StringMatchQ[uri,"paclet:"~~__],uri="paclet:"<>uri];
    Module[{lis={},pos=Drop[#,-3]&/@Position[cnew2,uri]},
      With[{len=Length/@pos},
        lis=Reverse/@Table[cnew2[[Apply[Sequence,pos[[j]]=Drop[pos[[j]],-1]]]][[1]],
			{j,Length[len]},{i,len[[j]]}]];
  Flatten[Map[First,lis,{2}],1]])];*)

(* Return link trail from a Tutorial filename *)

LinkTrailListFromFilename[filename_String /; StringMatchQ[filename,"paclet:tutorial/"~~__]] := 
Module[{trails = DocumentationBuild`Navigation`$TutPages},
If[ ListQ@trails,
	LinkTrailListFromFilename[filename, trails],
	(* Navigation`$Pages not a list *)
	Message[LinkTrailListFromFilename::list, trails]; 
	DocumentationBuild`Navigation`$TutPages = {};
		{}]
];

(* Return link trail from a Guide filename *)
LinkTrailListFromFilename[filename_String] := 
Module[{trails = DocumentationBuild`Navigation`$Pages},
If[ ListQ@trails,
	LinkTrailListFromFilename[filename, trails],
	(* Navigation`$Pages not a list *)
	Message[LinkTrailListFromFilename::list, trails]; 
	DocumentationBuild`Navigation`$Pages = {};
		{}]
];

(* No trail list *)
(* filename should always be a paclet uri *)
(* TODO: require that $NameToNumberRules, etc handle paclet uris *)
LinkTrailListFromFilename[filename_String, {}]:= {};
LinkTrailListFromFilename[filename_String]:= 
	If[ ListQ@DocumentationBuild`Navigation`$Pages, 
		LinkTrailListFromFilename[filename, DocumentationBuild`Navigation`$Pages], {}];

LinkTrailListFromFilename[filename_String /; StringMatchQ[filename, "paclet:ref/" ~~ __], data_List] :=
Module[{list, primaryguide, fn = filename},
    Which[

      (* normal Symbol ref page *)
      StringFreeQ[fn, "ref/message/"],
        primaryguide = Quiet["PrimaryGuide" /. (filename /. DocumentationBuild`Export`$CoreInformation["English"])];
        (* next line does a check to see if ref page has an entry in the $CoreInformation data set *)
        If[primaryguide === Quiet[("PrimaryGuide" /. filename)], Message[LinkTrailListFromFilename::nodat,filename];Return[{}]];
        (* continue as normal *)
        If[primaryguide === (* XX Root guide rename change XX *)"paclet:guide/WolframRoot", {primaryguide}, 
        list = Cases[data,
            {StringReplace[primaryguide, {"paclet:guide/"->"", ".nb"->""}] /. $NameToNumberRules, trail_} :> trail, Infinity] /. $NumberToNameRules;
        Join[#, {primaryguide,filename}] & /@ Flatten[list //. {a___, b_String /; ! StringMatchQ[b, "paclet:*"], c___} :> {a, "paclet:guide/" <> b, c}, 1]],

      (* message page code goes here eventually... *)
      !StringFreeQ[fn, "ref/message/"],
        (*code here*)
        {},

      (* catch all default value to prevent docs breaks for now *)
      True, {}]
];    

LinkTrailListFromFilename[filename_String /; StringMatchQ[filename, "paclet:guide/" ~~ __], data_List] := 
Module[{list},
	list = Cases[data, 
			{StringReplace[filename, {"paclet:guide/"->"", ".nb"->""}] /. $NameToNumberRules, trail_} :> trail, Infinity] /. $NumberToNameRules;
(*Print["List: "<>ToString@list];*)
	Append[#, filename]& /@ Flatten[list //. {a___, b_String /; ! StringMatchQ[b, "paclet:*"], c___} :> {a, "paclet:guide/" <> b, c}, 1]
];

LinkTrailListFromFilename[filename_String /; StringMatchQ[filename, "paclet:tutorial/" ~~ __], data_List] :=
    Module[{list},
	list = Cases[data, 
			{StringReplace[filename, {"paclet:tutorial/"->"", ".nb"->""}] /. $TutNameToNumberRules, trail_} :> trail, Infinity] /. $TutNumberToNameRules;
(*Print["List: "<>ToString@list];*)
	Append[#, filename]& /@ Flatten[list //. {a___, b_String /; ! StringMatchQ[b, "paclet:*"], c___} :> {a, "paclet:tutorial/" <> b, c}, 1]
];

LinkTrailListFromFilename[filename_String /; StringMatchQ[filename, "paclet:howto/" ~~ __], data_List] :=
    (*commenting until howto link trails are ready*)
    (*(If[tutflag =!= True, tutflag = tuttrailinit[]];
    FindLinkTrail[filename]);*){};

LinkTrailListFromFilename::list = "Navigation'$Pages not a list: `1`";
LinkTrailListFromFilename::nodat = "The specified URI, `1`, does not have an entry in $CoreInformation.";

anchors = "Section";
GetTutorialAnchors[uri_String, nb_, lang_:"English"] :=
 Module[{cells},
 	cells = Cases[nb, (cell:Cell[c_, ___, sty:anchors, ___, CellID->id_, ___] /;
 		FreeQ[cell, "FutureExample"|"TentativeExample", Infinity]) :> {c, id, sty}, Infinity];
 	cells
 ];

GetExamplePageData::excl = "Page `` is futurized or otherwise excluded.";
(* examplefile is a filename to a Featured Example page *)
GetExamplePageData[examplefile_String] := 
 Module[{nbdata = Quiet[Get[examplefile]], title, filename, links},
  If[FreeQ[{DocumentationBuild`Utils`DocumentFlag[nbdata]}, "FutureFlag" | "InternalFlag" | "ExcisedFlag" | "TemporaryFlag", Infinity],
  	
  title = 
   First@Cases[nbdata, 
     Cell[t_, ___, "FeaturedExampleTitle", ___] :> t, Infinity];
  filename = FileBaseName[examplefile];
  links = 
   Cases[nbdata, 
    Cell[TextData[ButtonBox[n_, ___, ButtonData -> uri_, ___]], ___, 
      "FeaturedExampleMoreAbout", ___] :> {n, uri}, Infinity];
  {filename, title, links},
  Message[GetExamplePageData::excl, FileBaseName[examplefile]];$Failed]];
  
(* size of thumbnail linking to example pages in guide pages *)
thumbnailsize = {140, 105};

(* examplefile is a filename to a Featured Example page *)
GetExamplePageThumbnail[examplefile_String] :=
   GetExamplePageThumbnail[DocumentationBuild`Utils`GetQuietly[examplefile]];
   
GetExamplePageThumbnail[examplenb_Notebook] :=
 Module[{nbdata = examplenb, img},
  If[FreeQ[nbdata, "\"Thumbnail Placeholder\"", Infinity], 
   img = ImageResize[
     Image[Rasterize[
       Last[Cases[nbdata, Cell[___, "AlternateThumbnail", ___], 
         Infinity]]]], thumbnailsize],
   img = ImageResize[
     Image[Rasterize[
       Last[Cases[nbdata, Cell[___, "Output", ___], Infinity]]]], 
     thumbnailsize]
   ]; img];

(* examplepagedata is a list of data from mapping GetExamplePageData[ ] over the example page directory *)
(* output is list of {thumbnail, title, filebasename (for linking)} *)
(* This version is an easier way to generate thumbnails if you already have the data generated *)
GetExamplePageThumbnail[examplepagedir_String, examplepagedata_List] :=
 Module[{},
 	{GetExamplePageThumbnail[FileNameJoin[{examplepagedir, #[[1]] <> ".nb"}]], #[[2]], #[[1]]}& /@ 
 	  examplepagedata
 ];

(* guideURI is a paclet URI of a guide page.
   examplepagedata is the result of mapping GetExamplePageData[ ] over the example page directory. *)
GetFeaturedExampleLinksToGuide[guideURI_, examplepagedata_] :=
 Module[{fullURI}, 
  If[examplepagedata =!= {},
  	If[StringMatchQ[guideURI, "paclet:*"], fullURI = guideURI, 
   fullURI = "paclet:" <> guideURI];
  {#[[1]], #[[2]]} & /@ 
   Select[examplepagedata, MemberQ[#[[3]], fullURI, Infinity] &],
   {}]];
   
GetListOfHowToLandingPagesAndSubpages[howtoDir_] := 
 Module[{files = FileNames["*.nb", howtoDir], landingpages}, 
  landingpages = 
   Select[files, 
    Module[{nb = Get[#]}, 
      MemberQ[nb, Cell[___, "Subsubsection", ___], Infinity] && 
       FreeQ[nb, Cell[___, "Text" | "Input", ___], Infinity]] &];
  {FileBaseName[#], 
     Flatten@Cases[Get[#], 
       Cell[c_, ___, "Subsubsection", ___] :> 
        DeleteDuplicates[
         Cases[{c}, 
          ButtonBox[___, 
            ButtonData -> uri_, ___] :> {StringReplace[
             Transmogrify`ConvertToString[c], "" -> ""], uri}, 
          Infinity]], Infinity]} & /@ landingpages];

(* ::Subsection:: *)
(*Forward/Back Navigation*)


(* ::Subsubsection:: *)
(*Two-button (forward, back only) approach*)


GetNavDestinations[uri_String, vbdata_List, lang_:"English"] :=
 Module[{uripos, return, foundflag = True},
  If[Length[vbdata] > 0,
   uripos = Position[vbdata, uri];
   If[uripos =!= {}, uripos = uripos[[1,1]], foundflag = False ];
   
   If[foundflag,
   	
   	If[uripos === 1,
   	return = {"Back" -> None, "Forward" -> vbdata[[uripos+1]]},
   	
   	If[uripos === Length[vbdata],
   		return = {"Back" -> vbdata[[uripos-1]], "Forward" -> None},
        return = {"Back" -> vbdata[[uripos-1]],
                  "Forward" -> vbdata[[uripos+1]]}
      ]
     ],
     
     return = {"Back" -> None, "Forward" -> None}
    ],
    
   return = {"Back" -> None, "Forward" -> None}
  ];
  return
]  


(* ::Subsubsection:: *)
(*Seven-button approach (unused)*)


(* Forward/Back navigation *) 

GetBackUpForwardFromParent[directory_String, uri_, fromuri_, lang_: "English"] := 
 Module[{nbdata = 
    Quiet[Get[ToFileName[directory, 
       StringReplace[uri, {"paclet:" -> "", "tutorial/" -> ""}] <> 
       ".nb"]]], casestmp, style, cellsofstyle, pos, backone, forwardone, up, defaultval = None},
  (*Print["uri: ",uri,"fromuri: ",fromuri];*)
  style = 
   If[(casestmp = Cases[nbdata, 
     Cell[contents___, 
       style : ("TOCChapter" | "TOCSection" | "TOCSubsection" | 
          "TOCSubsubsection" | "TOCSubsubsubsection" | 
          "TOCSubsubsubsubsection" | 
          "TOCSubsubsubsubsubsection"), ___] /; 
         MemberQ[contents, ButtonBox[___, ButtonData -> fromuri, ___], Infinity] :> 
           style, Infinity]) =!= {}, 
      First[casestmp], {}];
  cellsofstyle = 
   Cases[nbdata, c : Cell[___, style, ___] /; ! FreeQ[c, ButtonBox], 
    Infinity];
  pos = If[cellsofstyle === {}, {}, Position[cellsofstyle, 
     Cell[contents___] /;  
        MemberQ[{contents}, ButtonBox[___, ButtonData -> fromuri, ___], Infinity]][[1, 1]]];
  backone = If[pos > 1, cellsofstyle[[pos - 1]], defaultval, defaultval];
  forwardone = 
   If[pos < Length[cellsofstyle], cellsofstyle[[pos + 1]], defaultval, defaultval];
  backone = 
   If[backone =!= defaultval, If[(casestmp = Cases[backone, 
    ButtonBox[___, ButtonData->u_, ___] :> u, Infinity]) =!= {}, First[casestmp], defaultval], defaultval];
  forwardone = 
   If[forwardone =!= defaultval, If[(casestmp = Cases[forwardone, 
    ButtonBox[___, ButtonData->u_, ___] :> u, Infinity]) =!= {}, First[casestmp], defaultval], defaultval];
  up = DocumentationBuild`Info`Private`GetLinkTrails[uri, {}][[1, -1]];
  {backone, up, forwardone}];
  
GetForwardBack[directory_String, uri_, lang_: "English"] := 
 Module[{nbdata, filename, backthree, backtwo, backone, up, 
   forwardone, forwardtwo, forwardthree, oldparent, parent, parenturi,
    isvb = False, stop = False, defaultval = None, nbflag},
  up = backone = forwardone = backtwo = forwardtwo = backthree = forwardthree = defaultval;
  If[uri === "paclet:tutorial/VirtualBookOverview", stop = True; 
   isvb = True];
  filename = ToFileName[directory, 
    StringReplace[uri, {"paclet:" -> "", "tutorial/" -> ""}] <> ".nb"];
  nbdata = Quiet[Get[filename]];
  If[StringMatchQ[nbflag = ToString[DocumentationBuild`Info`GetNotebookFlag[nbdata]], "ExcisedFlag"|"InternalFlag"] ||
  	StringMatchQ[nbflag, "FutureFlag"] && FreeQ[nbdata, "UnderDevelopment"], stop = True];
  If[! stop, 
   up = parent = 
     DocumentationBuild`Info`Private`GetLinkTrails[uri, {}][[1, -1]];
   If[parent === "paclet:tutorial/VirtualBookOverview", isvb = True];
   parenturi = parent; 
   oldparent = parent; {backone, parent, forwardone} = 
    GetBackUpForwardFromParent[directory, parent, uri, lang]; 
   If[isvb, stop = True];
   
   (* If the link trail has a guide page in it, then that link trail 
      has been hardcoded and isn't to be trusted.  All stop! *)
   If[StringMatchQ[oldparent, "paclet:*guide/*"], 
   	up = backone = forwardone = backtwo = forwardtwo = backthree = forwardthree = defaultval; stop = True], 
   	
   up = backone = forwardone = backtwo = forwardtwo = backthree = forwardthree = defaultval];
  If[! stop, 
   If[parent === "paclet:tutorial/VirtualBookOverview", isvb = True]; 
   oldparent = parent; {backtwo, parent, forwardtwo} = 
    GetBackUpForwardFromParent[directory, parent, parenturi, lang]; 
   parenturi = oldparent;
   If[isvb, stop = True],
   
   (* VB root is only one jump back, so "next tutorial" and "next chapter" don't apply *)
   backtwo = backone;
   forwardtwo = forwardone;
   backone = forwardone = defaultval];
  If[! stop, 
   If[parent === "paclet:tutorial/VirtualBookOverview", isvb = True]; 
   oldparent = parent; {backthree, parent, forwardthree} = 
    GetBackUpForwardFromParent[directory, parent, parenturi, lang]; 
   parenturi = oldparent;
   If[isvb, stop = True], 
   
   (* VB root is only two jumps back, so "next tutorial" doesn't apply *)
   backthree = backtwo;
   forwardthree = forwardtwo;
   backtwo = backone;
   forwardtwo = forwardone;
   backone = forwardone = defaultval];
  {"BackBook" -> backthree, "BackChapter" -> backtwo, 
  	"BackTutorial" -> backone, "UpOneLevel" -> up, "ForwardTutorial" -> forwardone, 
  	"ForwardChapter" -> forwardtwo, "ForwardBook" -> forwardthree}]


End[]

EndPackage[]



