/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.EndianUtils;
import org.apache.commons.io.IOUtils;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.ps.PSGenerator;
import org.apache.fop.render.ps.PSResource;
import org.apache.fop.util.ASCIIHexOutputStream;
import org.apache.fop.util.SubInputStream;

public class PSFontUtils {
    static /* synthetic */ Class class$org$apache$fop$render$ps$PSFontUtils;

    public static Map writeFontDict(PSGenerator gen, FontInfo fontInfo) throws IOException {
        String key;
        gen.commentln("%FOPBeginFontDict");
        gen.writeln("/FOPFonts 100 dict dup begin");
        Map fonts = fontInfo.getFonts();
        HashMap<String, PSResource> fontResources = new HashMap<String, PSResource>();
        Iterator iter = fonts.keySet().iterator();
        while (iter.hasNext()) {
            CustomFont cf;
            InputStream in;
            key = (String)iter.next();
            Typeface tf = (Typeface)fonts.get(key);
            if (tf instanceof LazyFont) {
                tf = ((LazyFont)tf).getRealFont();
            }
            PSResource fontRes = new PSResource("font", tf.getFontName());
            fontResources.put(key, fontRes);
            boolean embeddedFont = false;
            if (FontType.TYPE1 == tf.getFontType() && tf instanceof CustomFont && (in = PSFontUtils.getInputStreamOnFont(gen, cf = (CustomFont)tf)) != null) {
                gen.writeDSCComment("BeginResource", fontRes);
                PSFontUtils.embedType1Font(gen, in);
                gen.writeDSCComment("EndResource");
                gen.notifyResourceUsage(fontRes, false);
                embeddedFont = true;
            }
            if (!embeddedFont) {
                gen.writeDSCComment("IncludeResource", fontRes);
            }
            gen.commentln("%FOPBeginFontKey: " + key);
            gen.writeln("/" + key + " /" + tf.getFontName() + " def");
            gen.commentln("%FOPEndFontKey");
        }
        gen.writeln("end def");
        gen.commentln("%FOPEndFontDict");
        gen.commentln("%FOPBeginFontReencode");
        PSFontUtils.defineWinAnsiEncoding(gen);
        iter = fonts.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            Typeface fm = (Typeface)fonts.get(key);
            if (null == fm.getEncoding()) continue;
            if ("WinAnsiEncoding".equals(fm.getEncoding())) {
                gen.writeln("/" + fm.getFontName() + " findfont");
                gen.writeln("dup length dict begin");
                gen.writeln("  {1 index /FID ne {def} {pop pop} ifelse} forall");
                gen.writeln("  /Encoding " + fm.getEncoding() + " def");
                gen.writeln("  currentdict");
                gen.writeln("end");
                gen.writeln("/" + fm.getFontName() + " exch definefont pop");
                continue;
            }
            gen.commentln("%WARNING: Only WinAnsiEncoding is supported. Font '" + fm.getFontName() + "' asks for: " + fm.getEncoding());
        }
        gen.commentln("%FOPEndFontReencode");
        return fontResources;
    }

    private static void embedType1Font(PSGenerator gen, InputStream in) throws IOException {
        boolean finished = false;
        block5: while (!finished) {
            int segIndicator = in.read();
            if (segIndicator < 0) {
                throw new IOException("Unexpected end-of-file while reading segment indicator");
            }
            if (segIndicator != 128) {
                throw new IOException("Expected ASCII 128, found: " + segIndicator);
            }
            int segType = in.read();
            if (segType < 0) {
                throw new IOException("Unexpected end-of-file while reading segment type");
            }
            int dataSegLen = 0;
            switch (segType) {
                case 1: {
                    String line;
                    dataSegLen = EndianUtils.readSwappedInteger((InputStream)in);
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new SubInputStream(in, dataSegLen), "US-ASCII"));
                    while ((line = reader.readLine()) != null) {
                        gen.writeln(line);
                    }
                    continue block5;
                }
                case 2: {
                    dataSegLen = EndianUtils.readSwappedInteger((InputStream)in);
                    SubInputStream sin = new SubInputStream(in, dataSegLen);
                    ASCIIHexOutputStream hexOut = new ASCIIHexOutputStream(gen.getOutputStream());
                    IOUtils.copy((InputStream)sin, (OutputStream)hexOut);
                    gen.newLine();
                    continue block5;
                }
                case 3: {
                    finished = true;
                    continue block5;
                }
            }
            throw new IOException("Unsupported segment type: " + segType);
        }
    }

    private static InputStream getInputStreamOnFont(PSGenerator gen, CustomFont font) throws IOException {
        if (font.isEmbeddable()) {
            Source source = null;
            if (font.getEmbedFileName() != null) {
                source = gen.resolveURI(font.getEmbedFileName());
            }
            if (source == null && font.getEmbedResourceName() != null) {
                source = new StreamSource((class$org$apache$fop$render$ps$PSFontUtils == null ? (class$org$apache$fop$render$ps$PSFontUtils = PSFontUtils.class$("org.apache.fop.render.ps.PSFontUtils")) : class$org$apache$fop$render$ps$PSFontUtils).getResourceAsStream(font.getEmbedResourceName()));
            }
            if (source == null) {
                return null;
            }
            InputStream in = null;
            if (source instanceof StreamSource) {
                in = ((StreamSource)source).getInputStream();
            }
            if (in == null && source.getSystemId() != null) {
                try {
                    in = new URL(source.getSystemId()).openStream();
                }
                catch (MalformedURLException e) {
                    new FileNotFoundException("File not found. URL could not be resolved: " + e.getMessage());
                }
            }
            if (in == null) {
                return null;
            }
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            return in;
        }
        return null;
    }

    private static void defineWinAnsiEncoding(PSGenerator gen) throws IOException {
        gen.writeln("/WinAnsiEncoding [");
        for (int i = 0; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            char ch;
            String glyphname;
            if (i > 0) {
                if (i % 5 == 0) {
                    gen.newLine();
                } else {
                    gen.write(" ");
                }
            }
            if ("".equals(glyphname = Glyphs.charToGlyphName(ch = Glyphs.WINANSI_ENCODING[i]))) {
                gen.write("/.notdef");
                continue;
            }
            gen.write("/");
            gen.write(glyphname);
        }
        gen.newLine();
        gen.writeln("] def");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

