/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.layoutmgr.BlockLevelLayoutManager;
import org.apache.fop.layoutmgr.ElementListObserver;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.PageBreakingAlgorithm;
import org.apache.fop.layoutmgr.PageSequenceLayoutManager;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpaceResolver;
import org.apache.fop.traits.MinOptMax;

public abstract class AbstractBreaker {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$layoutmgr$AbstractBreaker == null ? (class$org$apache$fop$layoutmgr$AbstractBreaker = AbstractBreaker.class$("org.apache.fop.layoutmgr.AbstractBreaker")) : class$org$apache$fop$layoutmgr$AbstractBreaker));
    private int blockListIndex = 0;
    private List blockLists = null;
    protected int alignment;
    private int alignmentLast;
    protected MinOptMax footnoteSeparatorLength = new MinOptMax(0);
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$AbstractBreaker;

    protected abstract int getCurrentDisplayAlign();

    protected abstract boolean hasMoreContent();

    protected abstract void addAreas(PositionIterator var1, LayoutContext var2);

    protected abstract LayoutManager getTopLevelLM();

    protected abstract LayoutManager getCurrentChildLM();

    protected boolean isPartOverflowRecoveryActivated() {
        return true;
    }

    protected PageSequenceLayoutManager.PageViewportProvider getPageViewportProvider() {
        return null;
    }

    protected abstract LinkedList getNextKnuthElements(LayoutContext var1, int var2);

    public boolean isEmpty() {
        return this.blockLists.size() == 0;
    }

    protected void startPart(BlockSequence list, int breakClass) {
    }

    protected void handleEmptyContent() {
    }

    protected abstract void finishPart(PageBreakingAlgorithm var1, PageBreakPosition var2);

    protected LayoutContext createLayoutContext() {
        return new LayoutContext(0);
    }

    protected void updateLayoutContext(LayoutContext context) {
    }

    protected void observeElementList(List elementList) {
        ElementListObserver.observe(elementList, "breaker", null);
    }

    public void doLayout(int flowBPD) {
        this.doLayout(flowBPD, false);
    }

    public void doLayout(int flowBPD, boolean autoHeight) {
        LayoutContext childLC = this.createLayoutContext();
        childLC.setStackLimit(new MinOptMax(flowBPD));
        this.alignment = this.getCurrentDisplayAlign() == 162 ? 70 : 135;
        this.alignmentLast = 135;
        childLC.setBPAlignment(this.alignment);
        this.blockLists = new ArrayList();
        log.debug((Object)("PLM> flow BPD =" + flowBPD));
        int nextSequenceStartsOn = 8;
        while (this.hasMoreContent()) {
            this.blockLists.clear();
            nextSequenceStartsOn = this.getNextBlockList(childLC, nextSequenceStartsOn, this.blockLists);
            log.debug((Object)("PLM> blockLists.size() = " + this.blockLists.size()));
            this.blockListIndex = 0;
            while (this.blockListIndex < this.blockLists.size()) {
                BlockSequence blockList = (BlockSequence)this.blockLists.get(this.blockListIndex);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  blockListIndex = " + this.blockListIndex));
                    String pagina = blockList.startOn == 8 ? "any page" : (blockList.startOn == 100 ? "odd page" : "even page");
                    log.debug((Object)("  sequence starts on " + pagina));
                }
                this.observeElementList(blockList);
                log.debug((Object)("PLM> start of algorithm (" + this.getClass().getName() + "), flow BPD =" + flowBPD));
                PageBreakingAlgorithm alg = new PageBreakingAlgorithm(this.getTopLevelLM(), this.getPageViewportProvider(), this.alignment, this.alignmentLast, this.footnoteSeparatorLength, this.isPartOverflowRecoveryActivated(), autoHeight);
                BlockSequence effectiveList = this.alignment == 70 ? this.justifyBoxes(blockList, alg, flowBPD) : blockList;
                alg.setConstantLineWidth(flowBPD);
                int iOptPageCount = alg.findBreakingPoints(effectiveList, 1.0, true, 0);
                log.debug((Object)("PLM> iOptPageCount= " + iOptPageCount + " pageBreaks.size()= " + alg.getPageBreaks().size()));
                this.doPhase3(alg, iOptPageCount, blockList, effectiveList);
                ++this.blockListIndex;
            }
        }
    }

    protected abstract void doPhase3(PageBreakingAlgorithm var1, int var2, BlockSequence var3, BlockSequence var4);

    protected void addAreas(PageBreakingAlgorithm alg, int partCount, BlockSequence originalList, BlockSequence effectiveList) {
        ListIterator effectiveListIterator = effectiveList.listIterator();
        int startElementIndex = 0;
        int endElementIndex = 0;
        int lastBreak = -1;
        for (int p = 0; p < partCount; ++p) {
            KnuthElement firstElement;
            int lastBreakClass;
            PageBreakPosition pbp = (PageBreakPosition)alg.getPageBreaks().get(p);
            if (p == 0) {
                lastBreakClass = effectiveList.getStartOn();
            } else {
                KnuthElement lastBreakElement = effectiveList.getElement(endElementIndex);
                if (lastBreakElement.isPenalty()) {
                    KnuthPenalty pen = (KnuthPenalty)lastBreakElement;
                    lastBreakClass = pen.getBreakClass();
                } else {
                    lastBreakClass = 28;
                }
            }
            endElementIndex = pbp.getLeafPos();
            log.debug((Object)("PLM> part: " + (p + 1) + ", start at pos " + (startElementIndex += startElementIndex == 0 ? effectiveList.ignoreAtStart : 0) + ", break at pos " + endElementIndex));
            this.startPart(effectiveList, lastBreakClass);
            int displayAlign = this.getCurrentDisplayAlign();
            int notificationEndElementIndex = endElementIndex;
            if (((KnuthElement)effectiveList.get(endElementIndex -= endElementIndex == originalList.size() - 1 ? effectiveList.ignoreAtEnd : 0)).isGlue()) {
                --endElementIndex;
            }
            effectiveListIterator = effectiveList.listIterator(startElementIndex);
            while (effectiveListIterator.hasNext() && !(firstElement = (KnuthElement)effectiveListIterator.next()).isBox()) {
                ++startElementIndex;
            }
            if (startElementIndex <= endElementIndex) {
                int averageLineLength;
                log.debug((Object)("     addAreas from " + startElementIndex + " to " + endElementIndex));
                LayoutContext childLC = new LayoutContext(0);
                childLC.setSpaceAdjust(pbp.bpdAdjust);
                if (pbp.difference != 0 && displayAlign == 23) {
                    childLC.setSpaceBefore(pbp.difference / 2);
                } else if (pbp.difference != 0 && displayAlign == 3) {
                    childLC.setSpaceBefore(pbp.difference);
                } else if (pbp.difference != 0 && displayAlign == 163 && p < partCount - 1) {
                    int boxCount = 0;
                    effectiveListIterator = effectiveList.listIterator(startElementIndex);
                    while (effectiveListIterator.nextIndex() <= endElementIndex) {
                        KnuthElement tempEl = (KnuthElement)effectiveListIterator.next();
                        if (!tempEl.isBox() || tempEl.getW() <= 0) continue;
                        ++boxCount;
                    }
                    if (boxCount >= 2) {
                        childLC.setSpaceAfter(pbp.difference / (boxCount - 1));
                    }
                }
                if (displayAlign == 162 && (averageLineLength = this.optimizeLineLength(effectiveList, startElementIndex, endElementIndex)) != 0) {
                    childLC.setStackLimit(new MinOptMax(averageLineLength));
                }
                SpaceResolver.performConditionalsNotification(effectiveList, startElementIndex, notificationEndElementIndex, lastBreak);
                this.addAreas(new KnuthPossPosIter(effectiveList, startElementIndex, endElementIndex + 1), childLC);
            } else {
                this.handleEmptyContent();
            }
            this.finishPart(alg, pbp);
            lastBreak = endElementIndex;
            startElementIndex = pbp.getLeafPos() + 1;
        }
    }

    protected int handleSpanChange(LayoutContext childLC, int nextSequenceStartsOn) {
        return nextSequenceStartsOn;
    }

    protected int getNextBlockList(LayoutContext childLC, int nextSequenceStartsOn, List blockLists) {
        this.updateLayoutContext(childLC);
        childLC.signalSpanChange(0);
        LinkedList returnedList = this.getNextKnuthElements(childLC, this.alignment);
        if (returnedList != null) {
            if (returnedList.size() == 0) {
                nextSequenceStartsOn = this.handleSpanChange(childLC, nextSequenceStartsOn);
                return nextSequenceStartsOn;
            }
            BlockSequence blockList = new BlockSequence(nextSequenceStartsOn);
            nextSequenceStartsOn = this.handleSpanChange(childLC, nextSequenceStartsOn);
            Position breakPosition = null;
            if (((KnuthElement)returnedList.getLast()).isPenalty() && ((KnuthPenalty)returnedList.getLast()).getP() == -1000) {
                KnuthPenalty breakPenalty = (KnuthPenalty)returnedList.removeLast();
                breakPosition = breakPenalty.getPosition();
                switch (breakPenalty.getBreakClass()) {
                    case 104: {
                        log.debug((Object)"PLM> break - PAGE");
                        nextSequenceStartsOn = 8;
                        break;
                    }
                    case 28: {
                        log.debug((Object)"PLM> break - COLUMN");
                        nextSequenceStartsOn = 28;
                        break;
                    }
                    case 100: {
                        log.debug((Object)"PLM> break - ODD PAGE");
                        nextSequenceStartsOn = 100;
                        break;
                    }
                    case 44: {
                        log.debug((Object)"PLM> break - EVEN PAGE");
                        nextSequenceStartsOn = 44;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Invalid break class: " + breakPenalty.getBreakClass());
                    }
                }
            }
            blockList.addAll(returnedList);
            BlockSequence seq = null;
            seq = blockList.endBlockSequence(breakPosition);
            if (seq != null) {
                blockLists.add(seq);
            }
        }
        return nextSequenceStartsOn;
    }

    private int optimizeLineLength(KnuthSequence effectiveList, int startElementIndex, int endElementIndex) {
        int boxCount = 0;
        int accumulatedLineLength = 0;
        int greatestMinimumLength = 0;
        ListIterator effectiveListIterator = effectiveList.listIterator(startElementIndex);
        while (effectiveListIterator.nextIndex() <= endElementIndex) {
            KnuthElement tempEl = (KnuthElement)effectiveListIterator.next();
            if (!(tempEl instanceof KnuthBlockBox)) continue;
            KnuthBlockBox blockBox = (KnuthBlockBox)tempEl;
            if (blockBox.getBPD() > 0) {
                log.debug((Object)("PSLM> nominal length of line = " + blockBox.getBPD()));
                log.debug((Object)("      range = " + blockBox.getIPDRange()));
                ++boxCount;
                accumulatedLineLength += ((KnuthBlockBox)tempEl).getBPD();
            }
            if (blockBox.getIPDRange().min <= greatestMinimumLength) continue;
            greatestMinimumLength = blockBox.getIPDRange().min;
        }
        int averageLineLength = 0;
        if (accumulatedLineLength > 0 && boxCount > 0) {
            averageLineLength = accumulatedLineLength / boxCount;
            log.debug((Object)("Average line length = " + averageLineLength));
            if (averageLineLength < greatestMinimumLength) {
                averageLineLength = greatestMinimumLength;
                log.debug((Object)("  Correction to: " + averageLineLength));
            }
        }
        return averageLineLength;
    }

    private BlockSequence justifyBoxes(BlockSequence blockList, PageBreakingAlgorithm alg, int availableBPD) {
        alg.setConstantLineWidth(availableBPD);
        int iOptPageNumber = alg.findBreakingPoints(blockList, 1.0, true, 0);
        log.debug((Object)("PLM> iOptPageNumber= " + iOptPageNumber));
        ListIterator sequenceIterator = blockList.listIterator();
        ListIterator breakIterator = alg.getPageBreaks().listIterator();
        KnuthElement thisElement = null;
        while (breakIterator.hasNext()) {
            KnuthElement firstElement;
            PageBreakPosition thisBreak = (PageBreakPosition)breakIterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("| first page: break= " + thisBreak.getLeafPos() + " difference= " + thisBreak.difference + " ratio= " + thisBreak.bpdAdjust));
            }
            boolean accumulatedS = false;
            int adjustedDiff = 0;
            while (!(firstElement = (KnuthElement)sequenceIterator.next()).isBox()) {
                log.debug((Object)"PLM> ignoring glue or penalty element at the beginning of the sequence");
                if (!firstElement.isGlue()) continue;
                ((BlockLevelLayoutManager)firstElement.getLayoutManager()).discardSpace((KnuthGlue)firstElement);
            }
            int firstElementIndex = sequenceIterator.previousIndex();
            sequenceIterator.previous();
            MinOptMax lineNumberMaxAdjustment = new MinOptMax(0);
            MinOptMax spaceMaxAdjustment = new MinOptMax(0);
            double spaceAdjustmentRatio = 0.0;
            LinkedList<KnuthGlue> blockSpacesList = new LinkedList<KnuthGlue>();
            LinkedList<KnuthElement> unconfirmedList = new LinkedList<KnuthElement>();
            LinkedList<KnuthElement> adjustableLinesList = new LinkedList<KnuthElement>();
            boolean bBoxSeen = false;
            block7: while (sequenceIterator.hasNext() && sequenceIterator.nextIndex() <= thisBreak.getLeafPos()) {
                thisElement = (KnuthElement)sequenceIterator.next();
                if (thisElement.isGlue()) {
                    switch (((KnuthGlue)thisElement).getAdjustmentClass()) {
                        case 0: 
                        case 1: {
                            unconfirmedList.add(thisElement);
                            continue block7;
                        }
                        case 2: {
                            lineNumberMaxAdjustment.max += ((KnuthGlue)thisElement).getY();
                            lineNumberMaxAdjustment.min -= ((KnuthGlue)thisElement).getZ();
                            adjustableLinesList.add(thisElement);
                            continue block7;
                        }
                        case 3: {
                            continue block7;
                        }
                    }
                    continue;
                }
                if (!thisElement.isBox()) continue;
                if (!bBoxSeen) {
                    bBoxSeen = true;
                    continue;
                }
                if (unconfirmedList.size() <= 0) continue;
                while (unconfirmedList.size() > 0) {
                    KnuthGlue blockSpace = (KnuthGlue)unconfirmedList.removeFirst();
                    spaceMaxAdjustment.max += blockSpace.getY();
                    spaceMaxAdjustment.min -= blockSpace.getZ();
                    blockSpacesList.add(blockSpace);
                }
            }
            log.debug((Object)("| line number adj= " + lineNumberMaxAdjustment));
            log.debug((Object)("| space adj      = " + spaceMaxAdjustment));
            if (thisElement.isPenalty() && thisElement.getW() > 0) {
                log.debug((Object)"  mandatory variation to the number of lines!");
                ((BlockLevelLayoutManager)thisElement.getLayoutManager()).negotiateBPDAdjustment(thisElement.getW(), thisElement);
            }
            if (thisBreak.bpdAdjust != 0.0 && thisBreak.difference > 0 && thisBreak.difference <= spaceMaxAdjustment.max || thisBreak.difference < 0 && thisBreak.difference >= spaceMaxAdjustment.min) {
                spaceAdjustmentRatio = (double)thisBreak.difference / (double)(thisBreak.difference > 0 ? spaceMaxAdjustment.max : spaceMaxAdjustment.min);
                log.debug((Object)("single space: " + ((adjustedDiff += this.adjustBlockSpaces(blockSpacesList, thisBreak.difference, thisBreak.difference > 0 ? spaceMaxAdjustment.max : -spaceMaxAdjustment.min)) == thisBreak.difference || thisBreak.bpdAdjust == 0.0 ? "ok" : "ERROR")));
                continue;
            }
            if (thisBreak.bpdAdjust == 0.0) continue;
            log.debug((Object)("lines and space: " + ((adjustedDiff += this.adjustBlockSpaces(blockSpacesList, thisBreak.difference - (adjustedDiff += this.adjustLineNumbers(adjustableLinesList, thisBreak.difference, thisBreak.difference > 0 ? lineNumberMaxAdjustment.max : -lineNumberMaxAdjustment.min)), thisBreak.difference - adjustedDiff > 0 ? spaceMaxAdjustment.max : -spaceMaxAdjustment.min)) == thisBreak.difference || thisBreak.bpdAdjust == 0.0 ? "ok" : "ERROR")));
        }
        BlockSequence effectiveList = new BlockSequence(blockList.getStartOn());
        effectiveList.addAll(this.getCurrentChildLM().getChangedKnuthElements(blockList.subList(0, blockList.size() - blockList.ignoreAtEnd), 0));
        effectiveList.endSequence();
        ElementListObserver.observe(effectiveList, "breaker-effective", null);
        alg.getPageBreaks().clear();
        return effectiveList;
    }

    private int adjustBlockSpaces(LinkedList spaceList, int difference, int total) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AdjustBlockSpaces: difference " + difference + " / " + total + " on " + spaceList.size() + " spaces in block"));
        }
        ListIterator spaceListIterator = spaceList.listIterator();
        int adjustedDiff = 0;
        int partial = 0;
        while (spaceListIterator.hasNext()) {
            KnuthGlue blockSpace = (KnuthGlue)spaceListIterator.next();
            partial += difference > 0 ? blockSpace.getY() : blockSpace.getZ();
            if (log.isDebugEnabled()) {
                log.debug((Object)("available = " + partial + " / " + total));
                log.debug((Object)("competenza  = " + ((int)((float)partial * (float)difference / (float)total) - adjustedDiff) + " / " + difference));
            }
            int newAdjust = ((BlockLevelLayoutManager)blockSpace.getLayoutManager()).negotiateBPDAdjustment((int)((float)partial * (float)difference / (float)total) - adjustedDiff, blockSpace);
            adjustedDiff += newAdjust;
        }
        return adjustedDiff;
    }

    private int adjustLineNumbers(LinkedList lineList, int difference, int total) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("AdjustLineNumbers: difference " + difference + " / " + total + " on " + lineList.size() + " elements"));
        }
        ListIterator lineListIterator = lineList.listIterator();
        int adjustedDiff = 0;
        int partial = 0;
        while (lineListIterator.hasNext()) {
            KnuthGlue line = (KnuthGlue)lineListIterator.next();
            int newAdjust = ((BlockLevelLayoutManager)line.getLayoutManager()).negotiateBPDAdjustment((int)((float)(partial += difference > 0 ? line.getY() : line.getZ()) * (float)difference / (float)total) - adjustedDiff, line);
            adjustedDiff += newAdjust;
        }
        return adjustedDiff;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class BlockSequence
    extends KnuthSequence {
        private int startOn;

        public BlockSequence(int iStartOn) {
            this.startOn = iStartOn;
        }

        public int getStartOn() {
            return this.startOn;
        }

        public BlockSequence endBlockSequence(Position breakPosition) {
            KnuthSequence temp = super.endSequence(breakPosition);
            if (temp != null) {
                BlockSequence returnSequence = new BlockSequence(this.startOn);
                returnSequence.addAll(temp);
                returnSequence.ignoreAtEnd = this.ignoreAtEnd;
                return returnSequence;
            }
            return null;
        }
    }

    public static class PageBreakPosition
    extends LeafPosition {
        double bpdAdjust;
        int difference;
        int footnoteFirstListIndex;
        int footnoteFirstElementIndex;
        int footnoteLastListIndex;
        int footnoteLastElementIndex;

        PageBreakPosition(LayoutManager lm, int iBreakIndex, int ffli, int ffei, int flli, int flei, double bpdA, int diff) {
            super(lm, iBreakIndex);
            this.bpdAdjust = bpdA;
            this.difference = diff;
            this.footnoteFirstListIndex = ffli;
            this.footnoteFirstElementIndex = ffei;
            this.footnoteLastListIndex = flli;
            this.footnoteLastElementIndex = flei;
        }
    }
}

