/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontMetrics;

public class FontInfo {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$fonts$FontInfo == null ? (class$org$apache$fop$fonts$FontInfo = FontInfo.class$("org.apache.fop.fonts.FontInfo")) : class$org$apache$fop$fonts$FontInfo));
    private Map usedFonts;
    private Map triplets = new HashMap();
    private Map fonts = new HashMap();
    private Collection loggedFontKeys;
    static /* synthetic */ Class class$org$apache$fop$fonts$FontInfo;

    public FontInfo() {
        this.usedFonts = new HashMap();
    }

    public boolean isSetupValid() {
        return this.triplets.containsKey("any,normal,400");
    }

    public void addFontProperties(String name, String family, String style, int weight) {
        String key = FontInfo.createFontKey(family, style, weight);
        this.triplets.put(key, name);
    }

    public void addMetrics(String name, FontMetrics metrics) {
        this.fonts.put(name, metrics);
    }

    private String fontLookup(String family, String style, int weight, boolean substFont) {
        String key = FontInfo.createFontKey(family, style, weight);
        String f = (String)this.triplets.get(key);
        if (f == null) {
            f = this.findAdjustWeight(family, style, weight);
            if (!substFont && f == null) {
                return null;
            }
            if (f == null) {
                this.notifyFontReplacement(key);
                key = FontInfo.createFontKey("any", style, weight);
                f = (String)this.triplets.get(key);
            }
            if (f == null) {
                f = (String)this.triplets.get("any,normal,400");
            }
        }
        this.usedFonts.put(f, this.fonts.get(f));
        return f;
    }

    public String fontLookup(String family, String style, int weight) {
        return this.fontLookup(family, style, weight, true);
    }

    public String fontLookup(String[] family, String style, int weight) {
        for (int i = 0; i < family.length; ++i) {
            String key = this.fontLookup(family[i], style, weight, i >= family.length - 1);
            if (key == null) continue;
            return key;
        }
        throw new IllegalStateException("fontLookup must return a key on the last call");
    }

    private void notifyFontReplacement(String key) {
        if (this.loggedFontKeys == null) {
            this.loggedFontKeys = new HashSet();
        }
        if (!this.loggedFontKeys.contains(key)) {
            this.loggedFontKeys.add(key);
            log.warn((Object)("Font '" + key + "' not found. Substituting with default font."));
        }
    }

    public String findAdjustWeight(String family, String style, int weight) {
        String key;
        String f = null;
        int newWeight = weight;
        if (newWeight < 400) {
            while (f == null && newWeight > 0) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = (String)this.triplets.get(key);
            }
        } else if (newWeight == 500) {
            key = FontInfo.createFontKey(family, style, 400);
            f = (String)this.triplets.get(key);
        } else if (newWeight > 500) {
            while (f == null && newWeight < 1000) {
                key = FontInfo.createFontKey(family, style, newWeight += 100);
                f = (String)this.triplets.get(key);
            }
            newWeight = weight;
            while (f == null && newWeight > 400) {
                key = FontInfo.createFontKey(family, style, newWeight -= 100);
                f = (String)this.triplets.get(key);
            }
        }
        if (f == null) {
            key = FontInfo.createFontKey(family, style, 400);
            f = (String)this.triplets.get(key);
        }
        return f;
    }

    public boolean hasFont(String family, String style, int weight) {
        String key = FontInfo.createFontKey(family, style, weight);
        return this.triplets.containsKey(key);
    }

    public static String createFontKey(String family, String style, int weight) {
        return family + "," + style + "," + weight;
    }

    public Map getFonts() {
        return Collections.unmodifiableMap(this.fonts);
    }

    public Map getUsedFonts() {
        return this.usedFonts;
    }

    public FontMetrics getMetricsFor(String fontName) {
        FontMetrics metrics = (FontMetrics)this.fonts.get(fontName);
        this.usedFonts.put(fontName, metrics);
        return metrics;
    }

    private String getTripletFor(String fontName) {
        ArrayList foundTriplets = new ArrayList();
        Iterator iter = this.triplets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry tripletEntry = iter.next();
            if (!fontName.equals((String)tripletEntry.getValue())) continue;
            foundTriplets.add(tripletEntry.getKey());
        }
        if (foundTriplets.size() > 0) {
            Collections.sort(foundTriplets);
            return (String)foundTriplets.get(0);
        }
        return null;
    }

    public String getFontStyleFor(String fontName) {
        String triplet = this.getTripletFor(fontName);
        if (triplet != null) {
            return triplet.substring(triplet.indexOf(44) + 1, triplet.lastIndexOf(44));
        }
        return "";
    }

    public String getFontWeightFor(String fontName) {
        String triplet = this.getTripletFor(fontName);
        if (triplet != null) {
            return triplet.substring(triplet.lastIndexOf(44) + 1);
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

