/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.fo.properties.SpaceProperty;

public abstract class AbstractGraphics
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginInline commonMarginInline;
    private CommonRelativePosition commonRelativePosition;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private LengthRangeProperty blockProgressionDimension;
    private Length contentHeight;
    private String contentType;
    private Length contentWidth;
    private int displayAlign;
    private int dominantBaseline;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private SpaceProperty lineHeight;
    private int overflow;
    private int scaling;
    private int scalingMethod;
    private int textAlign;
    private Length width;

    public AbstractGraphics(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginInline = pList.getMarginInlineProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.contentHeight = pList.get(72).getLength();
        this.contentType = pList.get(73).getString();
        this.contentWidth = pList.get(74).getLength();
        this.displayAlign = pList.get(81).getEnum();
        this.dominantBaseline = pList.get(82).getEnum();
        this.height = pList.get(106).getLength();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.lineHeight = pList.get(131).getSpace();
        this.overflow = pList.get(153).getEnum();
        this.scaling = pList.get(193).getEnum();
        this.scalingMethod = pList.get(194).getEnum();
        this.textAlign = pList.get(223).getEnum();
        this.width = pList.get(241).getLength();
    }

    public int computeXOffset(int ipd, int cwidth) {
        int xoffset = 0;
        switch (this.textAlign) {
            case 23: {
                xoffset = (ipd - cwidth) / 2;
                break;
            }
            case 39: {
                xoffset = ipd - cwidth;
                break;
            }
            case 135: {
                break;
            }
        }
        return xoffset;
    }

    public int computeYOffset(int bpd, int cheight) {
        int yoffset = 0;
        switch (this.displayAlign) {
            case 13: {
                break;
            }
            case 3: {
                yoffset = bpd - cheight;
                break;
            }
            case 23: {
                yoffset = (bpd - cheight) / 2;
                break;
            }
        }
        return yoffset;
    }

    public String getId() {
        return this.id;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getHeight() {
        return this.height;
    }

    public Length getWidth() {
        return this.width;
    }

    public Length getContentHeight() {
        return this.contentHeight;
    }

    public Length getContentWidth() {
        return this.contentWidth;
    }

    public int getScaling() {
        return this.scaling;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public Length getAlignmentAdjust() {
        return this.alignmentAdjust;
    }

    public int getAlignmentBaseline() {
        return this.alignmentBaseline;
    }

    public Length getBaselineShift() {
        return this.baselineShift;
    }

    public int getDominantBaseline() {
        return this.dominantBaseline;
    }

    public abstract int getIntrinsicWidth();

    public abstract int getIntrinsicHeight();
}

