/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.cli.InputHandler;
import org.apache.fop.fo.Constants;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.util.CommandLineLogger;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CommandLineOptions
implements Constants {
    public static final int RENDER_NONE = -1;
    private Boolean showConfiguration = Boolean.FALSE;
    private Boolean suppressLowLevelAreas = Boolean.FALSE;
    private File userConfigFile = null;
    private File fofile = null;
    private File xsltfile = null;
    private File xmlfile = null;
    private File outfile = null;
    private int inputmode = 0;
    private String outputmode = null;
    private FOUserAgent foUserAgent;
    private InputHandler inputHandler;
    private Log log;
    private Vector xsltParams = null;
    static /* synthetic */ Class class$org$apache$fop$util$CommandLineLogger;

    public CommandLineOptions() {
        LogFactory logFactory = LogFactory.getFactory();
        if (System.getProperty("org.apache.commons.logging.Log") == null) {
            logFactory.setAttribute("org.apache.commons.logging.Log", (Object)(class$org$apache$fop$util$CommandLineLogger == null ? (class$org$apache$fop$util$CommandLineLogger = CommandLineOptions.class$("org.apache.fop.util.CommandLineLogger")) : class$org$apache$fop$util$CommandLineLogger).getName());
            this.setLogLevel("info");
        }
        this.log = LogFactory.getLog((String)"FOP");
    }

    public void parse(String[] args) throws FOPException, IOException {
        boolean optionsParsed = true;
        this.foUserAgent = new FOUserAgent();
        try {
            optionsParsed = this.parseOptions(args);
            if (optionsParsed) {
                if (this.showConfiguration == Boolean.TRUE) {
                    this.dumpConfiguration();
                }
                this.checkSettings();
                this.createUserConfig();
                this.addXSLTParameter("fop-output-format", this.getOutputFormat());
                this.addXSLTParameter("fop-version", Version.getVersion());
            }
        }
        catch (FOPException e) {
            CommandLineOptions.printUsage();
            throw e;
        }
        catch (FileNotFoundException e) {
            CommandLineOptions.printUsage();
            throw e;
        }
        this.inputHandler = this.createInputHandler();
        if (this.outputmode.equals("application/X-fop-awt-preview")) {
            AWTRenderer renderer = new AWTRenderer();
            renderer.setRenderable(this.inputHandler);
            renderer.setUserAgent(this.foUserAgent);
            this.foUserAgent.setRendererOverride(renderer);
        }
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public Log getLogger() {
        return this.log;
    }

    private void addXSLTParameter(String name, String value) {
        if (this.xsltParams == null) {
            this.xsltParams = new Vector();
        }
        this.xsltParams.addElement(name);
        this.xsltParams.addElement(value);
    }

    private boolean parseOptions(String[] args) throws FOPException {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-x") || args[i].equals("--dump-config")) {
                this.showConfiguration = Boolean.TRUE;
                continue;
            }
            if (args[i].equals("-c")) {
                i += this.parseConfigurationOption(args, i);
                continue;
            }
            if (args[i].equals("-l")) {
                i += this.parseLanguageOption(args, i);
                continue;
            }
            if (args[i].equals("-s")) {
                this.suppressLowLevelAreas = Boolean.TRUE;
                continue;
            }
            if (args[i].equals("-d")) {
                this.setLogOption("debug", "debug");
                continue;
            }
            if (args[i].equals("-r")) {
                this.foUserAgent.setStrictValidation(false);
                continue;
            }
            if (args[i].equals("-dpi")) {
                i += this.parseResolution(args, i);
                continue;
            }
            if (args[i].equals("-q") || args[i].equals("--quiet")) {
                this.setLogOption("quiet", "error");
                continue;
            }
            if (args[i].equals("-fo")) {
                i += this.parseFOInputOption(args, i);
                continue;
            }
            if (args[i].equals("-xsl")) {
                i += this.parseXSLInputOption(args, i);
                continue;
            }
            if (args[i].equals("-xml")) {
                i += this.parseXMLInputOption(args, i);
                continue;
            }
            if (args[i].equals("-awt")) {
                i += this.parseAWTOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-pdf")) {
                i += this.parsePDFOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-mif")) {
                i += this.parseMIFOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-rtf")) {
                i += this.parseRTFOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-tiff")) {
                i += this.parseTIFFOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-png")) {
                i += this.parsePNGOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-print")) {
                if ((i += this.parsePrintOutputOption(args, i)) + 1 >= args.length || !args[i + 1].equals("help")) continue;
                this.printUsagePrintOutput();
                return false;
            }
            if (args[i].equals("-pcl")) {
                i += this.parsePCLOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-ps")) {
                i += this.parsePostscriptOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-txt")) {
                i += this.parseTextOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-svg")) {
                i += this.parseSVGOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-afp")) {
                i += this.parseAFPOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-foout")) {
                i += this.parseFOOutputOption(args, i);
                continue;
            }
            if (args[i].equals("-out")) {
                i += this.parseCustomOutputOption(args, i);
                continue;
            }
            if (args[i].charAt(0) != '-') {
                i += this.parseUnknownOption(args, i);
                continue;
            }
            if (args[i].equals("-at")) {
                i += this.parseAreaTreeOption(args, i);
                continue;
            }
            if (args[i].equals("-v")) {
                System.out.println("FOP Version " + Version.getVersion());
                continue;
            }
            if (args[i].equals("-param")) {
                if (i + 2 < args.length) {
                    String name = args[++i];
                    String expression = args[++i];
                    this.addXSLTParameter(name, expression);
                    continue;
                }
                throw new FOPException("invalid param usage: use -param <name> <value>");
            }
            if (args[i].equals("-o")) {
                i += this.parsePDFOwnerPassword(args, i);
                continue;
            }
            if (args[i].equals("-u")) {
                i += this.parsePDFUserPassword(args, i);
                continue;
            }
            if (args[i].equals("-noprint")) {
                this.getPDFEncryptionParams().setAllowPrint(false);
                continue;
            }
            if (args[i].equals("-nocopy")) {
                this.getPDFEncryptionParams().setAllowCopyContent(false);
                continue;
            }
            if (args[i].equals("-noedit")) {
                this.getPDFEncryptionParams().setAllowEditContent(false);
                continue;
            }
            if (args[i].equals("-noannotations")) {
                this.getPDFEncryptionParams().setAllowEditAnnotations(false);
                continue;
            }
            CommandLineOptions.printUsage();
            return false;
        }
        return true;
    }

    private int parseConfigurationOption(String[] args, int i) throws FOPException {
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("if you use '-c', you must specify the name of the configuration file");
        }
        this.userConfigFile = new File(args[i + 1]);
        return 1;
    }

    private int parseLanguageOption(String[] args, int i) throws FOPException {
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("if you use '-l', you must specify a language");
        }
        Locale.setDefault(new Locale(args[i + 1], ""));
        return 1;
    }

    private int parseResolution(String[] args, int i) throws FOPException {
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("if you use '-dpi', you must specify a resolution (dots per inch)");
        }
        this.foUserAgent.setTargetResolution(Integer.parseInt(args[i + 1]));
        return 1;
    }

    private int parseFOInputOption(String[] args, int i) throws FOPException {
        this.inputmode = 1;
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the fo file for the '-fo' option");
        }
        this.fofile = new File(args[i + 1]);
        return 1;
    }

    private int parseXSLInputOption(String[] args, int i) throws FOPException {
        this.inputmode = 2;
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the stylesheet file for the '-xsl' option");
        }
        this.xsltfile = new File(args[i + 1]);
        return 1;
    }

    private int parseXMLInputOption(String[] args, int i) throws FOPException {
        this.inputmode = 2;
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the input file for the '-xml' option");
        }
        this.xmlfile = new File(args[i + 1]);
        return 1;
    }

    private int parseAWTOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/X-fop-awt-preview");
        return 0;
    }

    private int parsePDFOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/pdf");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the PDF output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseMIFOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/mif");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the MIF output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseRTFOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/rtf");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the RTF output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseTIFFOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("image/tiff");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the TIFF output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parsePNGOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("image/png");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the PNG output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parsePrintOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/X-fop-print");
        return 0;
    }

    private int parsePCLOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/x-pcl");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the PDF output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parsePostscriptOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/postscript");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the PostScript output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseTextOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("text/plain");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the text output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseSVGOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("image/svg+xml");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the SVG output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseAFPOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/x-afp");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the AFP output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseFOOutputOption(String[] args, int i) throws FOPException {
        this.setOutputMode("text/xsl");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the FO output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private int parseCustomOutputOption(String[] args, int i) throws FOPException {
        String mime = null;
        if ((i + 1 < args.length || args[i + 1].charAt(0) != '-') && "list".equals(mime = args[i + 1])) {
            String[] mimes = this.foUserAgent.getRendererFactory().listSupportedMimeTypes();
            System.out.println("Supported MIME types:");
            for (int j = 0; j < mimes.length; ++j) {
                System.out.println("  " + mimes[j]);
            }
            System.exit(0);
        }
        if (i + 2 >= args.length || args[i + 1].charAt(0) == '-' || args[i + 2].charAt(0) == '-') {
            throw new FOPException("you must specify the output format and the output file");
        }
        this.setOutputMode(mime);
        this.outfile = new File(args[i + 2]);
        return 2;
    }

    private int parseUnknownOption(String[] args, int i) throws FOPException {
        if (this.inputmode == 0) {
            this.inputmode = 1;
            this.fofile = new File(args[i]);
        } else if (this.outputmode == null) {
            this.outputmode = "application/pdf";
            this.outfile = new File(args[i]);
        } else {
            throw new FOPException("Don't know what to do with " + args[i]);
        }
        return 0;
    }

    private int parseAreaTreeOption(String[] args, int i) throws FOPException {
        this.setOutputMode("application/X-fop-areatree");
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            throw new FOPException("you must specify the area-tree output file");
        }
        this.outfile = new File(args[i + 1]);
        return 1;
    }

    private PDFEncryptionParams getPDFEncryptionParams() throws FOPException {
        if (this.foUserAgent.getPDFEncryptionParams() == null) {
            if (!PDFEncryptionManager.checkAvailableAlgorithms()) {
                throw new FOPException("PDF encryption requested but it is not available. Please make sure MD5 and RC4 algorithms are available.");
            }
            this.foUserAgent.setPDFEncryptionParams(new PDFEncryptionParams());
        }
        return this.foUserAgent.getPDFEncryptionParams();
    }

    private int parsePDFOwnerPassword(String[] args, int i) throws FOPException {
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            this.getPDFEncryptionParams().setOwnerPassword("");
            return 0;
        }
        this.getPDFEncryptionParams().setOwnerPassword(args[i + 1]);
        return 1;
    }

    private int parsePDFUserPassword(String[] args, int i) throws FOPException {
        if (i + 1 == args.length || args[i + 1].charAt(0) == '-') {
            this.getPDFEncryptionParams().setUserPassword("");
            return 0;
        }
        this.getPDFEncryptionParams().setUserPassword(args[i + 1]);
        return 1;
    }

    private void setOutputMode(String mime) throws FOPException {
        if (this.outputmode != null) {
            throw new FOPException("you can only set one output method");
        }
        this.outputmode = mime;
    }

    private void setLogOption(String option, String level) {
        if (this.log instanceof CommandLineLogger || System.getProperty("org.apache.commons.logging.Log") == null) {
            this.setLogLevel(level);
        } else if (this.log != null) {
            this.log.warn((Object)("The option " + option + " can only be used"));
            this.log.warn((Object)"with FOP's command line logger,");
            this.log.warn((Object)"which is the default on the command line.");
            this.log.warn((Object)"Configure other loggers using Java system properties.");
        }
    }

    private void setLogLevel(String level) {
        LogFactory.getFactory().setAttribute("level", (Object)level);
        if (this.log instanceof CommandLineLogger) {
            ((CommandLineLogger)this.log).setLogLevel(level);
        }
    }

    private void checkSettings() throws FOPException, FileNotFoundException {
        if (this.inputmode == 0) {
            throw new FOPException("No input file specified");
        }
        if (this.outputmode == null) {
            throw new FOPException("No output file specified");
        }
        if ((this.outputmode.equals("application/X-fop-awt-preview") || this.outputmode.equals("application/X-fop-print")) && this.outfile != null) {
            throw new FOPException("Output file may not be specified for AWT or PRINT output");
        }
        if (this.inputmode == 2) {
            if (this.xmlfile == null) {
                throw new FOPException("XML file must be specified for the transform mode");
            }
            if (this.xsltfile == null) {
                throw new FOPException("XSLT file must be specified for the transform mode");
            }
            if (this.fofile != null) {
                this.log.warn((Object)("Can't use fo file with transform mode! Ignoring.\nYour input is \n xmlfile: " + this.xmlfile.getAbsolutePath() + "\nxsltfile: " + this.xsltfile.getAbsolutePath() + "\n  fofile: " + this.fofile.getAbsolutePath()));
            }
            if (!this.xmlfile.exists()) {
                throw new FileNotFoundException("Error: xml file " + this.xmlfile.getAbsolutePath() + " not found ");
            }
            if (!this.xsltfile.exists()) {
                throw new FileNotFoundException("Error: xsl file " + this.xsltfile.getAbsolutePath() + " not found ");
            }
        } else if (this.inputmode == 1) {
            if (this.outputmode.equals("text/xsl")) {
                throw new FOPException("FO output mode is only available if you use -xml and -xsl");
            }
            if (this.xmlfile != null || this.xsltfile != null) {
                this.log.warn((Object)"fo input mode, but xmlfile or xslt file are set:");
                this.log.error((Object)("xml file: " + this.xmlfile.toString()));
                this.log.error((Object)("xslt file: " + this.xsltfile.toString()));
            }
            if (!this.fofile.exists()) {
                throw new FileNotFoundException("Error: fo file " + this.fofile.getAbsolutePath() + " not found ");
            }
        }
    }

    private void createUserConfig() throws FOPException, IOException {
        if (this.userConfigFile == null) {
            return;
        }
        XMLReader parser = this.createParser();
        DefaultConfigurationBuilder configBuilder = new DefaultConfigurationBuilder(parser);
        Configuration userConfig = null;
        try {
            userConfig = configBuilder.buildFromFile(this.userConfigFile);
        }
        catch (SAXException e) {
            throw new FOPException(e);
        }
        catch (ConfigurationException e) {
            throw new FOPException((Exception)((Object)e));
        }
        this.foUserAgent.setUserConfig(userConfig);
    }

    protected String getOutputFormat() throws FOPException {
        if (this.outputmode == null) {
            throw new FOPException("Renderer has not been set!");
        }
        if (this.outputmode.equals("application/X-fop-areatree")) {
            this.foUserAgent.getRendererOptions().put("fineDetail", this.isCoarseAreaXml());
        }
        return this.outputmode;
    }

    private InputHandler createInputHandler() throws IllegalArgumentException {
        switch (this.inputmode) {
            case 1: {
                return new InputHandler(this.fofile);
            }
            case 2: {
                return new InputHandler(this.xmlfile, this.xsltfile, this.xsltParams);
            }
        }
        throw new IllegalArgumentException("Error creating InputHandler object.");
    }

    protected FOUserAgent getFOUserAgent() {
        return this.foUserAgent;
    }

    public File getFOFile() {
        return this.fofile;
    }

    public File getXMLFile() {
        return this.xmlfile;
    }

    public File getXSLFile() {
        return this.xsltfile;
    }

    public File getOutputFile() {
        return this.outfile;
    }

    public File getUserConfigFile() {
        return this.userConfigFile;
    }

    public Boolean isCoarseAreaXml() {
        return this.suppressLowLevelAreas;
    }

    public File getInputFile() {
        switch (this.inputmode) {
            case 1: {
                return this.fofile;
            }
            case 2: {
                return this.xmlfile;
            }
        }
        return this.fofile;
    }

    public static void printUsage() {
        System.err.println("\nUSAGE\nFop [options] [-fo|-xml] infile [-xsl file] [-awt|-pdf|-mif|-rtf|-tiff|-png|-pcl|-ps|-txt|-at|-print] <outfile>\n [OPTIONS]  \n  -d             debug mode   \n  -x             dump configuration settings  \n  -q             quiet mode  \n  -c cfg.xml     use additional configuration file cfg.xml\n  -l lang        the language to use for user information \n  -r             relaxed/less strict validation (where available)\n  -dpi xxx       target resolution in dots per inch (dpi) where xxx is a number\n  -s             for area tree XML, down to block areas only\n  -v             to show FOP version being used\n\n  -o [password]  PDF file will be encrypted with option owner password\n  -u [password]  PDF file will be encrypted with option user password\n  -noprint       PDF file will be encrypted without printing permission\n  -nocopy        PDF file will be encrypted without copy content permission\n  -noedit        PDF file will be encrypted without edit content permission\n  -noannotations PDF file will be encrypted without edit annotation permission\n\n [INPUT]  \n  infile            xsl:fo input file (the same as the next) \n  -fo  infile       xsl:fo input file  \n  -xml infile       xml input file, must be used together with -xsl \n  -xsl stylesheet   xslt stylesheet \n \n  -param name value <value> to use for parameter <name> in xslt stylesheet\n                    (repeat '-param name value' for each parameter)\n \n [OUTPUT] \n  outfile           input will be rendered as pdf file into outfile \n  -pdf outfile      input will be rendered as pdf file (outfile req'd) \n  -awt              input will be displayed on screen \n  -mif outfile      input will be rendered as mif file (outfile req'd)\n  -rtf outfile      input will be rendered as rtf file (outfile req'd)\n  -tiff outfile     input will be rendered as tiff file (outfile req'd)\n  -png outfile      input will be rendered as png file (outfile req'd)\n  -pcl outfile      input will be rendered as pcl file (outfile req'd) \n  -ps outfile       input will be rendered as PostScript file (outfile req'd) \n  -txt outfile      input will be rendered as text file (outfile req'd) \n  -svg outfile      input will be rendered as an svg slides file (outfile req'd) \n  -at outfile       representation of area tree as XML (outfile req'd) \n  -print            input file will be rendered and sent to the printer \n                    see options with \"-print help\" \n  -out mime outfile input will be rendered using the given MIME type\n                    (outfile req'd) Example: \"-out application/pdf D:\\out.pdf\"\n                    (Tip: \"-out list\" prints the list of supported MIME types)\n\n  -foout outfile    input will only be XSL transformed. The intermediate \n                    XSL-FO file is saved and no rendering is performed. \n                    (Only available if you use -xml and -xsl parameters)\n\n [Examples]\n  Fop foo.fo foo.pdf \n  Fop -fo foo.fo -pdf foo.pdf (does the same as the previous line)\n  Fop -xml foo.xml -xsl foo.xsl -pdf foo.pdf\n  Fop -xml foo.xml -xsl foo.xsl -foout foo.fo\n  Fop foo.fo -mif foo.mif\n  Fop foo.fo -rtf foo.rtf\n  Fop foo.fo -print or Fop -print foo.fo \n  Fop foo.fo -awt \n");
    }

    private void printUsagePrintOutput() {
        System.err.println("USAGE: -print [-Dstart=i] [-Dend=i] [-Dcopies=i] [-Deven=true|false]  org.apache.fop.apps.Fop (..) -print \nExample:\njava -Dstart=1 -Dend=2 org.apache.Fop.apps.Fop infile.fo -print ");
    }

    private void dumpConfiguration() {
        this.log.info((Object)"Input mode: ");
        switch (this.inputmode) {
            case 0: {
                this.log.info((Object)"not set");
                break;
            }
            case 1: {
                this.log.info((Object)"FO ");
                this.log.info((Object)("fo input file: " + this.fofile.toString()));
                break;
            }
            case 2: {
                this.log.info((Object)"xslt transformation");
                this.log.info((Object)("xml input file: " + this.xmlfile.toString()));
                this.log.info((Object)("xslt stylesheet: " + this.xsltfile.toString()));
                break;
            }
            default: {
                this.log.info((Object)"unknown input type");
            }
        }
        this.log.info((Object)"Output mode: ");
        if (this.outputmode == null) {
            this.log.info((Object)"not set");
        } else if ("application/X-fop-awt-preview".equals(this.outputmode)) {
            this.log.info((Object)"awt on screen");
            if (this.outfile != null) {
                this.log.error((Object)"awt mode, but outfile is set:");
                this.log.info((Object)("out file: " + this.outfile.toString()));
            }
        } else if ("application/X-fop-print".equals(this.outputmode)) {
            this.log.info((Object)"print directly");
            if (this.outfile != null) {
                this.log.error((Object)"print mode, but outfile is set:");
                this.log.error((Object)("out file: " + this.outfile.toString()));
            }
        } else if ("application/X-fop-areatree".equals(this.outputmode)) {
            this.log.info((Object)"area tree");
            this.log.info((Object)("output file: " + this.outfile.toString()));
        } else {
            this.log.info((Object)this.outputmode);
            this.log.info((Object)("output file: " + this.outfile.toString()));
        }
        this.log.info((Object)"OPTIONS");
        if (this.userConfigFile != null) {
            this.log.info((Object)("user configuration file: " + this.userConfigFile.toString()));
        } else {
            this.log.info((Object)"no user configuration file is used [default]");
        }
    }

    private XMLReader createParser() throws FOPException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new FOPException("Couldn't create XMLReader", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

