/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area.inline;

import java.util.List;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fonts.Font;

public class UnresolvedPageNumber
extends TextArea
implements Resolvable {
    private boolean resolved = false;
    private String pageIDRef;
    private Font font;
    private String text;

    public UnresolvedPageNumber(String id, Font f) {
        this.pageIDRef = id;
        this.font = f;
        this.text = "?";
    }

    public String[] getIDRefs() {
        return new String[]{this.pageIDRef};
    }

    public void resolveIDRef(String id, List pages) {
        if (this.pageIDRef.equals(id) && pages != null) {
            this.resolved = true;
            PageViewport page = (PageViewport)pages.get(0);
            this.removeText();
            this.addWord(page.getPageNumberString(), 0);
            this.updateIPD(this.getStringWidth(this.text));
            this.font = null;
        }
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean applyVariationFactor(double variationFactor, int lineStretch, int lineShrink) {
        return true;
    }

    private int getStringWidth(String str) {
        int width = 0;
        for (int count = 0; count < str.length(); ++count) {
            width += this.font.getCharWidth(str.charAt(count));
        }
        return width;
    }
}

